// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon Chime Voice Connector's emergency calling configuration.
 */
class DnisEmergencyCallingConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    val callingCountry: String? = builder.callingCountry
    /**
     * The DNIS phone number to route emergency calls to, in E.164 format.
     */
    val emergencyPhoneNumber: String? = builder.emergencyPhoneNumber
    /**
     * The DNIS phone number to route test emergency calls to, in E.164 format.
     */
    val testPhoneNumber: String? = builder.testPhoneNumber

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DnisEmergencyCallingConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DnisEmergencyCallingConfiguration(")
        append("callingCountry=$callingCountry,")
        append("emergencyPhoneNumber=*** Sensitive Data Redacted ***,")
        append("testPhoneNumber=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callingCountry?.hashCode() ?: 0
        result = 31 * result + (emergencyPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (testPhoneNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DnisEmergencyCallingConfiguration

        if (callingCountry != other.callingCountry) return false
        if (emergencyPhoneNumber != other.emergencyPhoneNumber) return false
        if (testPhoneNumber != other.testPhoneNumber) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DnisEmergencyCallingConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DnisEmergencyCallingConfiguration
        /**
         * The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
         */
        fun callingCountry(callingCountry: String): FluentBuilder
        /**
         * The DNIS phone number to route emergency calls to, in E.164 format.
         */
        fun emergencyPhoneNumber(emergencyPhoneNumber: String): FluentBuilder
        /**
         * The DNIS phone number to route test emergency calls to, in E.164 format.
         */
        fun testPhoneNumber(testPhoneNumber: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
         */
        var callingCountry: String?
        /**
         * The DNIS phone number to route emergency calls to, in E.164 format.
         */
        var emergencyPhoneNumber: String?
        /**
         * The DNIS phone number to route test emergency calls to, in E.164 format.
         */
        var testPhoneNumber: String?

        fun build(): DnisEmergencyCallingConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callingCountry: String? = null
        override var emergencyPhoneNumber: String? = null
        override var testPhoneNumber: String? = null

        constructor(x: DnisEmergencyCallingConfiguration) : this() {
            this.callingCountry = x.callingCountry
            this.emergencyPhoneNumber = x.emergencyPhoneNumber
            this.testPhoneNumber = x.testPhoneNumber
        }

        override fun build(): DnisEmergencyCallingConfiguration = DnisEmergencyCallingConfiguration(this)
        override fun callingCountry(callingCountry: String): FluentBuilder = apply { this.callingCountry = callingCountry }
        override fun emergencyPhoneNumber(emergencyPhoneNumber: String): FluentBuilder = apply { this.emergencyPhoneNumber = emergencyPhoneNumber }
        override fun testPhoneNumber(testPhoneNumber: String): FluentBuilder = apply { this.testPhoneNumber = testPhoneNumber }
    }
}
