// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Settings specific to the Amazon Transcribe Medical engine.
 */
class EngineTranscribeMedicalSettings private constructor(builder: BuilderImpl) {
    /**
     * The language code specified for the Amazon Transcribe Medical engine.
     */
    val languageCode: TranscribeMedicalLanguageCode? = builder.languageCode
    /**
     * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.
     */
    val region: TranscribeMedicalRegion? = builder.region
    /**
     * The specialty specified for the Amazon Transcribe Medical engine.
     */
    val specialty: TranscribeMedicalSpecialty? = builder.specialty
    /**
     * The type of transcription.
     */
    val type: TranscribeMedicalType? = builder.type
    /**
     * The name of the vocabulary passed to Amazon Transcribe Medical.
     */
    val vocabularyName: String? = builder.vocabularyName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EngineTranscribeMedicalSettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EngineTranscribeMedicalSettings(")
        append("languageCode=$languageCode,")
        append("region=$region,")
        append("specialty=$specialty,")
        append("type=$type,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (specialty?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EngineTranscribeMedicalSettings

        if (languageCode != other.languageCode) return false
        if (region != other.region) return false
        if (specialty != other.specialty) return false
        if (type != other.type) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EngineTranscribeMedicalSettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EngineTranscribeMedicalSettings
        /**
         * The language code specified for the Amazon Transcribe Medical engine.
         */
        fun languageCode(languageCode: TranscribeMedicalLanguageCode): FluentBuilder
        /**
         * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        fun region(region: TranscribeMedicalRegion): FluentBuilder
        /**
         * The specialty specified for the Amazon Transcribe Medical engine.
         */
        fun specialty(specialty: TranscribeMedicalSpecialty): FluentBuilder
        /**
         * The type of transcription.
         */
        fun type(type: TranscribeMedicalType): FluentBuilder
        /**
         * The name of the vocabulary passed to Amazon Transcribe Medical.
         */
        fun vocabularyName(vocabularyName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The language code specified for the Amazon Transcribe Medical engine.
         */
        var languageCode: TranscribeMedicalLanguageCode?
        /**
         * The AWS Region passed to Amazon Transcribe Medical. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        var region: TranscribeMedicalRegion?
        /**
         * The specialty specified for the Amazon Transcribe Medical engine.
         */
        var specialty: TranscribeMedicalSpecialty?
        /**
         * The type of transcription.
         */
        var type: TranscribeMedicalType?
        /**
         * The name of the vocabulary passed to Amazon Transcribe Medical.
         */
        var vocabularyName: String?

        fun build(): EngineTranscribeMedicalSettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var languageCode: TranscribeMedicalLanguageCode? = null
        override var region: TranscribeMedicalRegion? = null
        override var specialty: TranscribeMedicalSpecialty? = null
        override var type: TranscribeMedicalType? = null
        override var vocabularyName: String? = null

        constructor(x: EngineTranscribeMedicalSettings) : this() {
            this.languageCode = x.languageCode
            this.region = x.region
            this.specialty = x.specialty
            this.type = x.type
            this.vocabularyName = x.vocabularyName
        }

        override fun build(): EngineTranscribeMedicalSettings = EngineTranscribeMedicalSettings(this)
        override fun languageCode(languageCode: TranscribeMedicalLanguageCode): FluentBuilder = apply { this.languageCode = languageCode }
        override fun region(region: TranscribeMedicalRegion): FluentBuilder = apply { this.region = region }
        override fun specialty(specialty: TranscribeMedicalSpecialty): FluentBuilder = apply { this.specialty = specialty }
        override fun type(type: TranscribeMedicalType): FluentBuilder = apply { this.type = type }
        override fun vocabularyName(vocabularyName: String): FluentBuilder = apply { this.vocabularyName = vocabularyName }
    }
}
