// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Settings specific to the Amazon Transcribe engine.
 */
class EngineTranscribeSettings private constructor(builder: BuilderImpl) {
    /**
     * The language code specified for the Amazon Transcribe engine.
     */
    val languageCode: TranscribeLanguageCode? = builder.languageCode
    /**
     * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.
     */
    val region: TranscribeRegion? = builder.region
    /**
     * The filtering method passed to Amazon Transcribe.
     */
    val vocabularyFilterMethod: TranscribeVocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * The name of the vocabulary filter passed to Amazon Transcribe.
     */
    val vocabularyFilterName: String? = builder.vocabularyFilterName
    /**
     * The name of the vocabulary passed to Amazon Transcribe.
     */
    val vocabularyName: String? = builder.vocabularyName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EngineTranscribeSettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EngineTranscribeSettings(")
        append("languageCode=$languageCode,")
        append("region=$region,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EngineTranscribeSettings

        if (languageCode != other.languageCode) return false
        if (region != other.region) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EngineTranscribeSettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EngineTranscribeSettings
        /**
         * The language code specified for the Amazon Transcribe engine.
         */
        fun languageCode(languageCode: TranscribeLanguageCode): FluentBuilder
        /**
         * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        fun region(region: TranscribeRegion): FluentBuilder
        /**
         * The filtering method passed to Amazon Transcribe.
         */
        fun vocabularyFilterMethod(vocabularyFilterMethod: TranscribeVocabularyFilterMethod): FluentBuilder
        /**
         * The name of the vocabulary filter passed to Amazon Transcribe.
         */
        fun vocabularyFilterName(vocabularyFilterName: String): FluentBuilder
        /**
         * The name of the vocabulary passed to Amazon Transcribe.
         */
        fun vocabularyName(vocabularyName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The language code specified for the Amazon Transcribe engine.
         */
        var languageCode: TranscribeLanguageCode?
        /**
         * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        var region: TranscribeRegion?
        /**
         * The filtering method passed to Amazon Transcribe.
         */
        var vocabularyFilterMethod: TranscribeVocabularyFilterMethod?
        /**
         * The name of the vocabulary filter passed to Amazon Transcribe.
         */
        var vocabularyFilterName: String?
        /**
         * The name of the vocabulary passed to Amazon Transcribe.
         */
        var vocabularyName: String?

        fun build(): EngineTranscribeSettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var languageCode: TranscribeLanguageCode? = null
        override var region: TranscribeRegion? = null
        override var vocabularyFilterMethod: TranscribeVocabularyFilterMethod? = null
        override var vocabularyFilterName: String? = null
        override var vocabularyName: String? = null

        constructor(x: EngineTranscribeSettings) : this() {
            this.languageCode = x.languageCode
            this.region = x.region
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        override fun build(): EngineTranscribeSettings = EngineTranscribeSettings(this)
        override fun languageCode(languageCode: TranscribeLanguageCode): FluentBuilder = apply { this.languageCode = languageCode }
        override fun region(region: TranscribeRegion): FluentBuilder = apply { this.region = region }
        override fun vocabularyFilterMethod(vocabularyFilterMethod: TranscribeVocabularyFilterMethod): FluentBuilder = apply { this.vocabularyFilterMethod = vocabularyFilterMethod }
        override fun vocabularyFilterName(vocabularyFilterName: String): FluentBuilder = apply { this.vocabularyFilterName = vocabularyFilterName }
        override fun vocabularyName(vocabularyName: String): FluentBuilder = apply { this.vocabularyName = vocabularyName }
    }
}
