// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function ARN.
 */
class EventsConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The bot ID.
     */
    val botId: String? = builder.botId
    /**
     * Lambda function ARN that allows a bot to receive outgoing events.
     */
    val lambdaFunctionArn: String? = builder.lambdaFunctionArn
    /**
     * HTTPS endpoint that allows a bot to receive outgoing events.
     */
    val outboundEventsHttpsEndpoint: String? = builder.outboundEventsHttpsEndpoint

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventsConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventsConfiguration(")
        append("botId=$botId,")
        append("lambdaFunctionArn=*** Sensitive Data Redacted ***,")
        append("outboundEventsHttpsEndpoint=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (lambdaFunctionArn?.hashCode() ?: 0)
        result = 31 * result + (outboundEventsHttpsEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventsConfiguration

        if (botId != other.botId) return false
        if (lambdaFunctionArn != other.lambdaFunctionArn) return false
        if (outboundEventsHttpsEndpoint != other.outboundEventsHttpsEndpoint) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventsConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventsConfiguration
        /**
         * The bot ID.
         */
        fun botId(botId: String): FluentBuilder
        /**
         * Lambda function ARN that allows a bot to receive outgoing events.
         */
        fun lambdaFunctionArn(lambdaFunctionArn: String): FluentBuilder
        /**
         * HTTPS endpoint that allows a bot to receive outgoing events.
         */
        fun outboundEventsHttpsEndpoint(outboundEventsHttpsEndpoint: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The bot ID.
         */
        var botId: String?
        /**
         * Lambda function ARN that allows a bot to receive outgoing events.
         */
        var lambdaFunctionArn: String?
        /**
         * HTTPS endpoint that allows a bot to receive outgoing events.
         */
        var outboundEventsHttpsEndpoint: String?

        fun build(): EventsConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var botId: String? = null
        override var lambdaFunctionArn: String? = null
        override var outboundEventsHttpsEndpoint: String? = null

        constructor(x: EventsConfiguration) : this() {
            this.botId = x.botId
            this.lambdaFunctionArn = x.lambdaFunctionArn
            this.outboundEventsHttpsEndpoint = x.outboundEventsHttpsEndpoint
        }

        override fun build(): EventsConfiguration = EventsConfiguration(this)
        override fun botId(botId: String): FluentBuilder = apply { this.botId = botId }
        override fun lambdaFunctionArn(lambdaFunctionArn: String): FluentBuilder = apply { this.lambdaFunctionArn = lambdaFunctionArn }
        override fun outboundEventsHttpsEndpoint(outboundEventsHttpsEndpoint: String): FluentBuilder = apply { this.outboundEventsHttpsEndpoint = outboundEventsHttpsEndpoint }
    }
}
