// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



class ListChannelsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the AppInstance.
     */
    val appInstanceArn: String? = builder.appInstanceArn
    /**
     * The AppInstanceUserArn of the user that makes the API call.
     */
    val chimeBearer: String? = builder.chimeBearer
    /**
     * The maximum number of channels that you want to return.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token passed by previous API calls until all requested channels are returned.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The privacy setting. PUBLIC retrieves all the public channels.
     * PRIVATE retrieves private channels. Only an AppInstanceAdmin
     * can retrieve private channels.
     */
    val privacy: ChannelPrivacy? = builder.privacy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListChannelsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListChannelsRequest(")
        append("appInstanceArn=$appInstanceArn,")
        append("chimeBearer=$chimeBearer,")
        append("maxResults=$maxResults,")
        append("nextToken=*** Sensitive Data Redacted ***,")
        append("privacy=$privacy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appInstanceArn?.hashCode() ?: 0
        result = 31 * result + (chimeBearer?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (privacy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListChannelsRequest

        if (appInstanceArn != other.appInstanceArn) return false
        if (chimeBearer != other.chimeBearer) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (privacy != other.privacy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListChannelsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListChannelsRequest
        /**
         * The ARN of the AppInstance.
         */
        fun appInstanceArn(appInstanceArn: String): FluentBuilder
        /**
         * The AppInstanceUserArn of the user that makes the API call.
         */
        fun chimeBearer(chimeBearer: String): FluentBuilder
        /**
         * The maximum number of channels that you want to return.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token passed by previous API calls until all requested channels are returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The privacy setting. PUBLIC retrieves all the public channels.
         * PRIVATE retrieves private channels. Only an AppInstanceAdmin
         * can retrieve private channels.
         */
        fun privacy(privacy: ChannelPrivacy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the AppInstance.
         */
        var appInstanceArn: String?
        /**
         * The AppInstanceUserArn of the user that makes the API call.
         */
        var chimeBearer: String?
        /**
         * The maximum number of channels that you want to return.
         */
        var maxResults: Int?
        /**
         * The token passed by previous API calls until all requested channels are returned.
         */
        var nextToken: String?
        /**
         * The privacy setting. PUBLIC retrieves all the public channels.
         * PRIVATE retrieves private channels. Only an AppInstanceAdmin
         * can retrieve private channels.
         */
        var privacy: ChannelPrivacy?

        fun build(): ListChannelsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appInstanceArn: String? = null
        override var chimeBearer: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var privacy: ChannelPrivacy? = null

        constructor(x: ListChannelsRequest) : this() {
            this.appInstanceArn = x.appInstanceArn
            this.chimeBearer = x.chimeBearer
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.privacy = x.privacy
        }

        override fun build(): ListChannelsRequest = ListChannelsRequest(this)
        override fun appInstanceArn(appInstanceArn: String): FluentBuilder = apply { this.appInstanceArn = appInstanceArn }
        override fun chimeBearer(chimeBearer: String): FluentBuilder = apply { this.chimeBearer = chimeBearer }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun privacy(privacy: ChannelPrivacy): FluentBuilder = apply { this.privacy = privacy }
    }
}
