// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



class ListUsersRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime account ID.
     */
    val accountId: String? = builder.accountId
    /**
     * The maximum number of results to return in a single call. Defaults to 100.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Optional. The user email address used to filter results. Maximum 1.
     */
    val userEmail: String? = builder.userEmail
    /**
     * The user type.
     */
    val userType: UserType? = builder.userType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListUsersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListUsersRequest(")
        append("accountId=$accountId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("userEmail=*** Sensitive Data Redacted ***,")
        append("userType=$userType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (userEmail?.hashCode() ?: 0)
        result = 31 * result + (userType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListUsersRequest

        if (accountId != other.accountId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (userEmail != other.userEmail) return false
        if (userType != other.userType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListUsersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListUsersRequest
        /**
         * The Amazon Chime account ID.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The maximum number of results to return in a single call. Defaults to 100.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to use to retrieve the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Optional. The user email address used to filter results. Maximum 1.
         */
        fun userEmail(userEmail: String): FluentBuilder
        /**
         * The user type.
         */
        fun userType(userType: UserType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime account ID.
         */
        var accountId: String?
        /**
         * The maximum number of results to return in a single call. Defaults to 100.
         */
        var maxResults: Int?
        /**
         * The token to use to retrieve the next page of results.
         */
        var nextToken: String?
        /**
         * Optional. The user email address used to filter results. Maximum 1.
         */
        var userEmail: String?
        /**
         * The user type.
         */
        var userType: UserType?

        fun build(): ListUsersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var userEmail: String? = null
        override var userType: UserType? = null

        constructor(x: ListUsersRequest) : this() {
            this.accountId = x.accountId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.userEmail = x.userEmail
            this.userType = x.userType
        }

        override fun build(): ListUsersRequest = ListUsersRequest(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun userEmail(userEmail: String): FluentBuilder = apply { this.userEmail = userEmail }
        override fun userType(userType: UserType): FluentBuilder = apply { this.userType = userType }
    }
}
