// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A media capture pipeline object. A string consisting of an ID, source type, a source ARN, a sink type, and a sink ARN.
 */
class MediaCapturePipeline private constructor(builder: BuilderImpl) {
    /**
     * The time at which the capture pipeline was created, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The ID of a media capture pipeline.
     */
    val mediaPipelineId: String? = builder.mediaPipelineId
    /**
     * ARN of the destination to which the media artifacts are saved.
     */
    val sinkArn: String? = builder.sinkArn
    /**
     * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
     */
    val sinkType: MediaPipelineSinkType? = builder.sinkType
    /**
     * ARN of the source from which the media artifacts will be saved.
     */
    val sourceArn: String? = builder.sourceArn
    /**
     * Source type from which media artifacts are saved. You must use ChimeMeeting.
     */
    val sourceType: MediaPipelineSourceType? = builder.sourceType
    /**
     * The status of the media capture pipeline.
     */
    val status: MediaPipelineStatus? = builder.status
    /**
     * The time at which the capture pipeline was updated, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaCapturePipeline = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaCapturePipeline(")
        append("createdTimestamp=$createdTimestamp,")
        append("mediaPipelineId=$mediaPipelineId,")
        append("sinkArn=*** Sensitive Data Redacted ***,")
        append("sinkType=$sinkType,")
        append("sourceArn=*** Sensitive Data Redacted ***,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (mediaPipelineId?.hashCode() ?: 0)
        result = 31 * result + (sinkArn?.hashCode() ?: 0)
        result = 31 * result + (sinkType?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaCapturePipeline

        if (createdTimestamp != other.createdTimestamp) return false
        if (mediaPipelineId != other.mediaPipelineId) return false
        if (sinkArn != other.sinkArn) return false
        if (sinkType != other.sinkType) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaCapturePipeline = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaCapturePipeline
        /**
         * The time at which the capture pipeline was created, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The ID of a media capture pipeline.
         */
        fun mediaPipelineId(mediaPipelineId: String): FluentBuilder
        /**
         * ARN of the destination to which the media artifacts are saved.
         */
        fun sinkArn(sinkArn: String): FluentBuilder
        /**
         * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         */
        fun sinkType(sinkType: MediaPipelineSinkType): FluentBuilder
        /**
         * ARN of the source from which the media artifacts will be saved.
         */
        fun sourceArn(sourceArn: String): FluentBuilder
        /**
         * Source type from which media artifacts are saved. You must use ChimeMeeting.
         */
        fun sourceType(sourceType: MediaPipelineSourceType): FluentBuilder
        /**
         * The status of the media capture pipeline.
         */
        fun status(status: MediaPipelineStatus): FluentBuilder
        /**
         * The time at which the capture pipeline was updated, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time at which the capture pipeline was created, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The ID of a media capture pipeline.
         */
        var mediaPipelineId: String?
        /**
         * ARN of the destination to which the media artifacts are saved.
         */
        var sinkArn: String?
        /**
         * Destination type to which the media artifacts are saved. You must use an S3 Bucket.
         */
        var sinkType: MediaPipelineSinkType?
        /**
         * ARN of the source from which the media artifacts will be saved.
         */
        var sourceArn: String?
        /**
         * Source type from which media artifacts are saved. You must use ChimeMeeting.
         */
        var sourceType: MediaPipelineSourceType?
        /**
         * The status of the media capture pipeline.
         */
        var status: MediaPipelineStatus?
        /**
         * The time at which the capture pipeline was updated, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): MediaCapturePipeline
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTimestamp: Instant? = null
        override var mediaPipelineId: String? = null
        override var sinkArn: String? = null
        override var sinkType: MediaPipelineSinkType? = null
        override var sourceArn: String? = null
        override var sourceType: MediaPipelineSourceType? = null
        override var status: MediaPipelineStatus? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: MediaCapturePipeline) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.mediaPipelineId = x.mediaPipelineId
            this.sinkArn = x.sinkArn
            this.sinkType = x.sinkType
            this.sourceArn = x.sourceArn
            this.sourceType = x.sourceType
            this.status = x.status
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): MediaCapturePipeline = MediaCapturePipeline(this)
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun mediaPipelineId(mediaPipelineId: String): FluentBuilder = apply { this.mediaPipelineId = mediaPipelineId }
        override fun sinkArn(sinkArn: String): FluentBuilder = apply { this.sinkArn = sinkArn }
        override fun sinkType(sinkType: MediaPipelineSinkType): FluentBuilder = apply { this.sinkType = sinkType }
        override fun sourceArn(sourceArn: String): FluentBuilder = apply { this.sourceArn = sourceArn }
        override fun sourceType(sourceType: MediaPipelineSourceType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun status(status: MediaPipelineStatus): FluentBuilder = apply { this.status = status }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
