// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * A meeting created using the Amazon Chime SDK.
 */
class Meeting private constructor(builder: BuilderImpl) {
    /**
     * The external meeting ID.
     */
    val externalMeetingId: String? = builder.externalMeetingId
    /**
     * The media placement for the meeting.
     */
    val mediaPlacement: MediaPlacement? = builder.mediaPlacement
    /**
     * The Region in which you create the meeting. Available values: af-south-1, ap-northeast-1,
     * ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2, ca-central-1,
     * eu-central-1, eu-north-1, eu-south-1,
     * eu-west-1, eu-west-2, eu-west-3,
     * sa-east-1, us-east-1, us-east-2,
     * us-west-1, us-west-2.
     */
    val mediaRegion: String? = builder.mediaRegion
    /**
     * The Amazon Chime SDK meeting ID.
     */
    val meetingId: String? = builder.meetingId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Meeting = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Meeting(")
        append("externalMeetingId=*** Sensitive Data Redacted ***,")
        append("mediaPlacement=$mediaPlacement,")
        append("mediaRegion=$mediaRegion,")
        append("meetingId=$meetingId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalMeetingId?.hashCode() ?: 0
        result = 31 * result + (mediaPlacement?.hashCode() ?: 0)
        result = 31 * result + (mediaRegion?.hashCode() ?: 0)
        result = 31 * result + (meetingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Meeting

        if (externalMeetingId != other.externalMeetingId) return false
        if (mediaPlacement != other.mediaPlacement) return false
        if (mediaRegion != other.mediaRegion) return false
        if (meetingId != other.meetingId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Meeting = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Meeting
        /**
         * The external meeting ID.
         */
        fun externalMeetingId(externalMeetingId: String): FluentBuilder
        /**
         * The media placement for the meeting.
         */
        fun mediaPlacement(mediaPlacement: MediaPlacement): FluentBuilder
        /**
         * The Region in which you create the meeting. Available values: af-south-1, ap-northeast-1,
         * ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2, ca-central-1,
         * eu-central-1, eu-north-1, eu-south-1,
         * eu-west-1, eu-west-2, eu-west-3,
         * sa-east-1, us-east-1, us-east-2,
         * us-west-1, us-west-2.
         */
        fun mediaRegion(mediaRegion: String): FluentBuilder
        /**
         * The Amazon Chime SDK meeting ID.
         */
        fun meetingId(meetingId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The external meeting ID.
         */
        var externalMeetingId: String?
        /**
         * The media placement for the meeting.
         */
        var mediaPlacement: MediaPlacement?
        /**
         * The Region in which you create the meeting. Available values: af-south-1, ap-northeast-1,
         * ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2, ca-central-1,
         * eu-central-1, eu-north-1, eu-south-1,
         * eu-west-1, eu-west-2, eu-west-3,
         * sa-east-1, us-east-1, us-east-2,
         * us-west-1, us-west-2.
         */
        var mediaRegion: String?
        /**
         * The Amazon Chime SDK meeting ID.
         */
        var meetingId: String?

        fun build(): Meeting
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.MediaPlacement] inside the given [block]
         */
        fun mediaPlacement(block: MediaPlacement.DslBuilder.() -> kotlin.Unit) {
            this.mediaPlacement = MediaPlacement.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var externalMeetingId: String? = null
        override var mediaPlacement: MediaPlacement? = null
        override var mediaRegion: String? = null
        override var meetingId: String? = null

        constructor(x: Meeting) : this() {
            this.externalMeetingId = x.externalMeetingId
            this.mediaPlacement = x.mediaPlacement
            this.mediaRegion = x.mediaRegion
            this.meetingId = x.meetingId
        }

        override fun build(): Meeting = Meeting(this)
        override fun externalMeetingId(externalMeetingId: String): FluentBuilder = apply { this.externalMeetingId = externalMeetingId }
        override fun mediaPlacement(mediaPlacement: MediaPlacement): FluentBuilder = apply { this.mediaPlacement = mediaPlacement }
        override fun mediaRegion(mediaRegion: String): FluentBuilder = apply { this.mediaRegion = mediaRegion }
        override fun meetingId(meetingId: String): FluentBuilder = apply { this.meetingId = meetingId }
    }
}
