// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Origination routes define call distribution properties for your SIP hosts to receive inbound
 * calls using your Amazon Chime Voice Connector. Limit: Ten origination routes for each
 * Amazon Chime Voice Connector.
 */
class OriginationRoute private constructor(builder: BuilderImpl) {
    /**
     * The FQDN or IP address to contact for origination traffic.
     */
    val host: String? = builder.host
    /**
     * The designated origination route port. Defaults to 5060.
     */
    val port: Int? = builder.port
    /**
     * The priority associated with the host, with 1 being the highest priority. Higher priority
     * hosts are attempted first.
     */
    val priority: Int? = builder.priority
    /**
     * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     */
    val protocol: OriginationRouteProtocol? = builder.protocol
    /**
     * The weight associated with the host. If hosts are equal in priority, calls are redistributed among
     * them based on their relative weight.
     */
    val weight: Int? = builder.weight

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OriginationRoute = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OriginationRoute(")
        append("host=$host,")
        append("port=$port,")
        append("priority=$priority,")
        append("protocol=$protocol,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = host?.hashCode() ?: 0
        result = 31 * result + (port ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OriginationRoute

        if (host != other.host) return false
        if (port != other.port) return false
        if (priority != other.priority) return false
        if (protocol != other.protocol) return false
        if (weight != other.weight) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OriginationRoute = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OriginationRoute
        /**
         * The FQDN or IP address to contact for origination traffic.
         */
        fun host(host: String): FluentBuilder
        /**
         * The designated origination route port. Defaults to 5060.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The priority associated with the host, with 1 being the highest priority. Higher priority
         * hosts are attempted first.
         */
        fun priority(priority: Int): FluentBuilder
        /**
         * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
         */
        fun protocol(protocol: OriginationRouteProtocol): FluentBuilder
        /**
         * The weight associated with the host. If hosts are equal in priority, calls are redistributed among
         * them based on their relative weight.
         */
        fun weight(weight: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The FQDN or IP address to contact for origination traffic.
         */
        var host: String?
        /**
         * The designated origination route port. Defaults to 5060.
         */
        var port: Int?
        /**
         * The priority associated with the host, with 1 being the highest priority. Higher priority
         * hosts are attempted first.
         */
        var priority: Int?
        /**
         * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
         */
        var protocol: OriginationRouteProtocol?
        /**
         * The weight associated with the host. If hosts are equal in priority, calls are redistributed among
         * them based on their relative weight.
         */
        var weight: Int?

        fun build(): OriginationRoute
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var host: String? = null
        override var port: Int? = null
        override var priority: Int? = null
        override var protocol: OriginationRouteProtocol? = null
        override var weight: Int? = null

        constructor(x: OriginationRoute) : this() {
            this.host = x.host
            this.port = x.port
            this.priority = x.priority
            this.protocol = x.protocol
            this.weight = x.weight
        }

        override fun build(): OriginationRoute = OriginationRoute(this)
        override fun host(host: String): FluentBuilder = apply { this.host = host }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun priority(priority: Int): FluentBuilder = apply { this.priority = priority }
        override fun protocol(protocol: OriginationRouteProtocol): FluentBuilder = apply { this.protocol = protocol }
        override fun weight(weight: Int): FluentBuilder = apply { this.weight = weight }
    }
}
