// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice
 * Connector.
 */
class PhoneNumber private constructor(builder: BuilderImpl) {
    /**
     * The phone number associations.
     */
    val associations: List<PhoneNumberAssociation>? = builder.associations
    /**
     * The outbound calling name associated with the phone number.
     */
    val callingName: String? = builder.callingName
    /**
     * The outbound calling name status.
     */
    val callingNameStatus: CallingNameStatus? = builder.callingNameStatus
    /**
     * The phone number capabilities.
     */
    val capabilities: PhoneNumberCapabilities? = builder.capabilities
    /**
     * The phone number country. Format: ISO 3166-1 alpha-2.
     */
    val country: String? = builder.country
    /**
     * The phone number creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The deleted phone number timestamp, in ISO 8601 format.
     */
    val deletionTimestamp: Instant? = builder.deletionTimestamp
    /**
     * The phone number, in E.164 format.
     */
    val e164PhoneNumber: String? = builder.e164PhoneNumber
    /**
     * The phone number ID.
     */
    val phoneNumberId: String? = builder.phoneNumberId
    /**
     * The phone number product type.
     */
    val productType: PhoneNumberProductType? = builder.productType
    /**
     * The phone number status.
     */
    val status: PhoneNumberStatus? = builder.status
    /**
     * The phone number type.
     */
    val type: PhoneNumberType? = builder.type
    /**
     * The updated phone number timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PhoneNumber = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumber(")
        append("associations=$associations,")
        append("callingName=*** Sensitive Data Redacted ***,")
        append("callingNameStatus=$callingNameStatus,")
        append("capabilities=$capabilities,")
        append("country=$country,")
        append("createdTimestamp=$createdTimestamp,")
        append("deletionTimestamp=$deletionTimestamp,")
        append("e164PhoneNumber=*** Sensitive Data Redacted ***,")
        append("phoneNumberId=$phoneNumberId,")
        append("productType=$productType,")
        append("status=$status,")
        append("type=$type,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (callingName?.hashCode() ?: 0)
        result = 31 * result + (callingNameStatus?.hashCode() ?: 0)
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deletionTimestamp?.hashCode() ?: 0)
        result = 31 * result + (e164PhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberId?.hashCode() ?: 0)
        result = 31 * result + (productType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PhoneNumber

        if (associations != other.associations) return false
        if (callingName != other.callingName) return false
        if (callingNameStatus != other.callingNameStatus) return false
        if (capabilities != other.capabilities) return false
        if (country != other.country) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (deletionTimestamp != other.deletionTimestamp) return false
        if (e164PhoneNumber != other.e164PhoneNumber) return false
        if (phoneNumberId != other.phoneNumberId) return false
        if (productType != other.productType) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PhoneNumber = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PhoneNumber
        /**
         * The phone number associations.
         */
        fun associations(associations: List<PhoneNumberAssociation>): FluentBuilder
        /**
         * The outbound calling name associated with the phone number.
         */
        fun callingName(callingName: String): FluentBuilder
        /**
         * The outbound calling name status.
         */
        fun callingNameStatus(callingNameStatus: CallingNameStatus): FluentBuilder
        /**
         * The phone number capabilities.
         */
        fun capabilities(capabilities: PhoneNumberCapabilities): FluentBuilder
        /**
         * The phone number country. Format: ISO 3166-1 alpha-2.
         */
        fun country(country: String): FluentBuilder
        /**
         * The phone number creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The deleted phone number timestamp, in ISO 8601 format.
         */
        fun deletionTimestamp(deletionTimestamp: Instant): FluentBuilder
        /**
         * The phone number, in E.164 format.
         */
        fun e164PhoneNumber(e164PhoneNumber: String): FluentBuilder
        /**
         * The phone number ID.
         */
        fun phoneNumberId(phoneNumberId: String): FluentBuilder
        /**
         * The phone number product type.
         */
        fun productType(productType: PhoneNumberProductType): FluentBuilder
        /**
         * The phone number status.
         */
        fun status(status: PhoneNumberStatus): FluentBuilder
        /**
         * The phone number type.
         */
        fun type(type: PhoneNumberType): FluentBuilder
        /**
         * The updated phone number timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The phone number associations.
         */
        var associations: List<PhoneNumberAssociation>?
        /**
         * The outbound calling name associated with the phone number.
         */
        var callingName: String?
        /**
         * The outbound calling name status.
         */
        var callingNameStatus: CallingNameStatus?
        /**
         * The phone number capabilities.
         */
        var capabilities: PhoneNumberCapabilities?
        /**
         * The phone number country. Format: ISO 3166-1 alpha-2.
         */
        var country: String?
        /**
         * The phone number creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The deleted phone number timestamp, in ISO 8601 format.
         */
        var deletionTimestamp: Instant?
        /**
         * The phone number, in E.164 format.
         */
        var e164PhoneNumber: String?
        /**
         * The phone number ID.
         */
        var phoneNumberId: String?
        /**
         * The phone number product type.
         */
        var productType: PhoneNumberProductType?
        /**
         * The phone number status.
         */
        var status: PhoneNumberStatus?
        /**
         * The phone number type.
         */
        var type: PhoneNumberType?
        /**
         * The updated phone number timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): PhoneNumber
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.PhoneNumberCapabilities] inside the given [block]
         */
        fun capabilities(block: PhoneNumberCapabilities.DslBuilder.() -> kotlin.Unit) {
            this.capabilities = PhoneNumberCapabilities.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associations: List<PhoneNumberAssociation>? = null
        override var callingName: String? = null
        override var callingNameStatus: CallingNameStatus? = null
        override var capabilities: PhoneNumberCapabilities? = null
        override var country: String? = null
        override var createdTimestamp: Instant? = null
        override var deletionTimestamp: Instant? = null
        override var e164PhoneNumber: String? = null
        override var phoneNumberId: String? = null
        override var productType: PhoneNumberProductType? = null
        override var status: PhoneNumberStatus? = null
        override var type: PhoneNumberType? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: PhoneNumber) : this() {
            this.associations = x.associations
            this.callingName = x.callingName
            this.callingNameStatus = x.callingNameStatus
            this.capabilities = x.capabilities
            this.country = x.country
            this.createdTimestamp = x.createdTimestamp
            this.deletionTimestamp = x.deletionTimestamp
            this.e164PhoneNumber = x.e164PhoneNumber
            this.phoneNumberId = x.phoneNumberId
            this.productType = x.productType
            this.status = x.status
            this.type = x.type
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): PhoneNumber = PhoneNumber(this)
        override fun associations(associations: List<PhoneNumberAssociation>): FluentBuilder = apply { this.associations = associations }
        override fun callingName(callingName: String): FluentBuilder = apply { this.callingName = callingName }
        override fun callingNameStatus(callingNameStatus: CallingNameStatus): FluentBuilder = apply { this.callingNameStatus = callingNameStatus }
        override fun capabilities(capabilities: PhoneNumberCapabilities): FluentBuilder = apply { this.capabilities = capabilities }
        override fun country(country: String): FluentBuilder = apply { this.country = country }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun deletionTimestamp(deletionTimestamp: Instant): FluentBuilder = apply { this.deletionTimestamp = deletionTimestamp }
        override fun e164PhoneNumber(e164PhoneNumber: String): FluentBuilder = apply { this.e164PhoneNumber = e164PhoneNumber }
        override fun phoneNumberId(phoneNumberId: String): FluentBuilder = apply { this.phoneNumberId = phoneNumberId }
        override fun productType(productType: PhoneNumberProductType): FluentBuilder = apply { this.productType = productType }
        override fun status(status: PhoneNumberStatus): FluentBuilder = apply { this.status = status }
        override fun type(type: PhoneNumberType): FluentBuilder = apply { this.type = type }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
