// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The phone number associations, such as Amazon Chime account ID, Amazon Chime user ID, Amazon
 * Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.
 */
class PhoneNumberAssociation private constructor(builder: BuilderImpl) {
    /**
     * The timestamp of the phone number association, in ISO 8601 format.
     */
    val associatedTimestamp: Instant? = builder.associatedTimestamp
    /**
     * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
     * ID, or Amazon Chime Voice Connector group ID.
     */
    val name: PhoneNumberAssociationName? = builder.name
    /**
     * Contains the ID for the entity specified in Name.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PhoneNumberAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumberAssociation(")
        append("associatedTimestamp=$associatedTimestamp,")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedTimestamp?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PhoneNumberAssociation

        if (associatedTimestamp != other.associatedTimestamp) return false
        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PhoneNumberAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PhoneNumberAssociation
        /**
         * The timestamp of the phone number association, in ISO 8601 format.
         */
        fun associatedTimestamp(associatedTimestamp: Instant): FluentBuilder
        /**
         * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
         * ID, or Amazon Chime Voice Connector group ID.
         */
        fun name(name: PhoneNumberAssociationName): FluentBuilder
        /**
         * Contains the ID for the entity specified in Name.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The timestamp of the phone number association, in ISO 8601 format.
         */
        var associatedTimestamp: Instant?
        /**
         * Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector
         * ID, or Amazon Chime Voice Connector group ID.
         */
        var name: PhoneNumberAssociationName?
        /**
         * Contains the ID for the entity specified in Name.
         */
        var value: String?

        fun build(): PhoneNumberAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedTimestamp: Instant? = null
        override var name: PhoneNumberAssociationName? = null
        override var value: String? = null

        constructor(x: PhoneNumberAssociation) : this() {
            this.associatedTimestamp = x.associatedTimestamp
            this.name = x.name
            this.value = x.value
        }

        override fun build(): PhoneNumberAssociation = PhoneNumberAssociation(this)
        override fun associatedTimestamp(associatedTimestamp: Instant): FluentBuilder = apply { this.associatedTimestamp = associatedTimestamp }
        override fun name(name: PhoneNumberAssociationName): FluentBuilder = apply { this.name = name }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
