// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a phone number order created for Amazon Chime.
 */
class PhoneNumberOrder private constructor(builder: BuilderImpl) {
    /**
     * The phone number order creation time stamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The ordered phone number details, such as the phone number in E.164 format and the phone
     * number status.
     */
    val orderedPhoneNumbers: List<OrderedPhoneNumber>? = builder.orderedPhoneNumbers
    /**
     * The phone number order ID.
     */
    val phoneNumberOrderId: String? = builder.phoneNumberOrderId
    /**
     * The phone number order product type.
     */
    val productType: PhoneNumberProductType? = builder.productType
    /**
     * The status of the phone number order.
     */
    val status: PhoneNumberOrderStatus? = builder.status
    /**
     * The updated phone number order time stamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PhoneNumberOrder = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PhoneNumberOrder(")
        append("createdTimestamp=$createdTimestamp,")
        append("orderedPhoneNumbers=$orderedPhoneNumbers,")
        append("phoneNumberOrderId=$phoneNumberOrderId,")
        append("productType=$productType,")
        append("status=$status,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (orderedPhoneNumbers?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberOrderId?.hashCode() ?: 0)
        result = 31 * result + (productType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PhoneNumberOrder

        if (createdTimestamp != other.createdTimestamp) return false
        if (orderedPhoneNumbers != other.orderedPhoneNumbers) return false
        if (phoneNumberOrderId != other.phoneNumberOrderId) return false
        if (productType != other.productType) return false
        if (status != other.status) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PhoneNumberOrder = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PhoneNumberOrder
        /**
         * The phone number order creation time stamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The ordered phone number details, such as the phone number in E.164 format and the phone
         * number status.
         */
        fun orderedPhoneNumbers(orderedPhoneNumbers: List<OrderedPhoneNumber>): FluentBuilder
        /**
         * The phone number order ID.
         */
        fun phoneNumberOrderId(phoneNumberOrderId: String): FluentBuilder
        /**
         * The phone number order product type.
         */
        fun productType(productType: PhoneNumberProductType): FluentBuilder
        /**
         * The status of the phone number order.
         */
        fun status(status: PhoneNumberOrderStatus): FluentBuilder
        /**
         * The updated phone number order time stamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The phone number order creation time stamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The ordered phone number details, such as the phone number in E.164 format and the phone
         * number status.
         */
        var orderedPhoneNumbers: List<OrderedPhoneNumber>?
        /**
         * The phone number order ID.
         */
        var phoneNumberOrderId: String?
        /**
         * The phone number order product type.
         */
        var productType: PhoneNumberProductType?
        /**
         * The status of the phone number order.
         */
        var status: PhoneNumberOrderStatus?
        /**
         * The updated phone number order time stamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): PhoneNumberOrder
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTimestamp: Instant? = null
        override var orderedPhoneNumbers: List<OrderedPhoneNumber>? = null
        override var phoneNumberOrderId: String? = null
        override var productType: PhoneNumberProductType? = null
        override var status: PhoneNumberOrderStatus? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: PhoneNumberOrder) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.orderedPhoneNumbers = x.orderedPhoneNumbers
            this.phoneNumberOrderId = x.phoneNumberOrderId
            this.productType = x.productType
            this.status = x.status
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): PhoneNumberOrder = PhoneNumberOrder(this)
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun orderedPhoneNumbers(orderedPhoneNumbers: List<OrderedPhoneNumber>): FluentBuilder = apply { this.orderedPhoneNumbers = orderedPhoneNumbers }
        override fun phoneNumberOrderId(phoneNumberOrderId: String): FluentBuilder = apply { this.phoneNumberOrderId = phoneNumberOrderId }
        override fun productType(productType: PhoneNumberProductType): FluentBuilder = apply { this.productType = productType }
        override fun status(status: PhoneNumberOrderStatus): FluentBuilder = apply { this.status = status }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
