// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The proxy configuration for an Amazon Chime Voice Connector.
 */
class Proxy private constructor(builder: BuilderImpl) {
    /**
     * The default number of minutes allowed for proxy sessions.
     */
    val defaultSessionExpiryMinutes: Int? = builder.defaultSessionExpiryMinutes
    /**
     * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     */
    val disabled: Boolean? = builder.disabled
    /**
     * The phone number to route calls to after a proxy session expires.
     */
    val fallBackPhoneNumber: String? = builder.fallBackPhoneNumber
    /**
     * The countries for proxy phone numbers to be selected from.
     */
    val phoneNumberCountries: List<String>? = builder.phoneNumberCountries

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Proxy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Proxy(")
        append("defaultSessionExpiryMinutes=$defaultSessionExpiryMinutes,")
        append("disabled=$disabled,")
        append("fallBackPhoneNumber=*** Sensitive Data Redacted ***,")
        append("phoneNumberCountries=$phoneNumberCountries)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultSessionExpiryMinutes ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (fallBackPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Proxy

        if (defaultSessionExpiryMinutes != other.defaultSessionExpiryMinutes) return false
        if (disabled != other.disabled) return false
        if (fallBackPhoneNumber != other.fallBackPhoneNumber) return false
        if (phoneNumberCountries != other.phoneNumberCountries) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Proxy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Proxy
        /**
         * The default number of minutes allowed for proxy sessions.
         */
        fun defaultSessionExpiryMinutes(defaultSessionExpiryMinutes: Int): FluentBuilder
        /**
         * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         */
        fun disabled(disabled: Boolean): FluentBuilder
        /**
         * The phone number to route calls to after a proxy session expires.
         */
        fun fallBackPhoneNumber(fallBackPhoneNumber: String): FluentBuilder
        /**
         * The countries for proxy phone numbers to be selected from.
         */
        fun phoneNumberCountries(phoneNumberCountries: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The default number of minutes allowed for proxy sessions.
         */
        var defaultSessionExpiryMinutes: Int?
        /**
         * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         */
        var disabled: Boolean?
        /**
         * The phone number to route calls to after a proxy session expires.
         */
        var fallBackPhoneNumber: String?
        /**
         * The countries for proxy phone numbers to be selected from.
         */
        var phoneNumberCountries: List<String>?

        fun build(): Proxy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultSessionExpiryMinutes: Int? = null
        override var disabled: Boolean? = null
        override var fallBackPhoneNumber: String? = null
        override var phoneNumberCountries: List<String>? = null

        constructor(x: Proxy) : this() {
            this.defaultSessionExpiryMinutes = x.defaultSessionExpiryMinutes
            this.disabled = x.disabled
            this.fallBackPhoneNumber = x.fallBackPhoneNumber
            this.phoneNumberCountries = x.phoneNumberCountries
        }

        override fun build(): Proxy = Proxy(this)
        override fun defaultSessionExpiryMinutes(defaultSessionExpiryMinutes: Int): FluentBuilder = apply { this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes }
        override fun disabled(disabled: Boolean): FluentBuilder = apply { this.disabled = disabled }
        override fun fallBackPhoneNumber(fallBackPhoneNumber: String): FluentBuilder = apply { this.fallBackPhoneNumber = fallBackPhoneNumber }
        override fun phoneNumberCountries(phoneNumberCountries: List<String>): FluentBuilder = apply { this.phoneNumberCountries = phoneNumberCountries }
    }
}
