// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The proxy session for an Amazon Chime Voice Connector.
 */
class ProxySession private constructor(builder: BuilderImpl) {
    /**
     * The proxy session capabilities.
     */
    val capabilities: List<Capability>? = builder.capabilities
    /**
     * The created time stamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The ended time stamp, in ISO 8601 format.
     */
    val endedTimestamp: Instant? = builder.endedTimestamp
    /**
     * The number of minutes allowed for the proxy session.
     */
    val expiryMinutes: Int? = builder.expiryMinutes
    /**
     * The preference for matching the country or area code of the proxy phone number with that of the first participant.
     */
    val geoMatchLevel: GeoMatchLevel? = builder.geoMatchLevel
    /**
     * The country and area code for the proxy phone number.
     */
    val geoMatchParams: GeoMatchParams? = builder.geoMatchParams
    /**
     * The name of the proxy session.
     */
    val name: String? = builder.name
    /**
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     */
    val numberSelectionBehavior: NumberSelectionBehavior? = builder.numberSelectionBehavior
    /**
     * The proxy session participants.
     */
    val participants: List<Participant>? = builder.participants
    /**
     * The proxy session ID.
     */
    val proxySessionId: String? = builder.proxySessionId
    /**
     * The status of the proxy session.
     */
    val status: ProxySessionStatus? = builder.status
    /**
     * The updated time stamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp
    /**
     * The Amazon Chime voice connector ID.
     */
    val voiceConnectorId: String? = builder.voiceConnectorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ProxySession = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ProxySession(")
        append("capabilities=$capabilities,")
        append("createdTimestamp=$createdTimestamp,")
        append("endedTimestamp=$endedTimestamp,")
        append("expiryMinutes=$expiryMinutes,")
        append("geoMatchLevel=$geoMatchLevel,")
        append("geoMatchParams=$geoMatchParams,")
        append("name=$name,")
        append("numberSelectionBehavior=$numberSelectionBehavior,")
        append("participants=$participants,")
        append("proxySessionId=$proxySessionId,")
        append("status=$status,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (expiryMinutes ?: 0)
        result = 31 * result + (geoMatchLevel?.hashCode() ?: 0)
        result = 31 * result + (geoMatchParams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberSelectionBehavior?.hashCode() ?: 0)
        result = 31 * result + (participants?.hashCode() ?: 0)
        result = 31 * result + (proxySessionId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ProxySession

        if (capabilities != other.capabilities) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (endedTimestamp != other.endedTimestamp) return false
        if (expiryMinutes != other.expiryMinutes) return false
        if (geoMatchLevel != other.geoMatchLevel) return false
        if (geoMatchParams != other.geoMatchParams) return false
        if (name != other.name) return false
        if (numberSelectionBehavior != other.numberSelectionBehavior) return false
        if (participants != other.participants) return false
        if (proxySessionId != other.proxySessionId) return false
        if (status != other.status) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ProxySession = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ProxySession
        /**
         * The proxy session capabilities.
         */
        fun capabilities(capabilities: List<Capability>): FluentBuilder
        /**
         * The created time stamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The ended time stamp, in ISO 8601 format.
         */
        fun endedTimestamp(endedTimestamp: Instant): FluentBuilder
        /**
         * The number of minutes allowed for the proxy session.
         */
        fun expiryMinutes(expiryMinutes: Int): FluentBuilder
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        fun geoMatchLevel(geoMatchLevel: GeoMatchLevel): FluentBuilder
        /**
         * The country and area code for the proxy phone number.
         */
        fun geoMatchParams(geoMatchParams: GeoMatchParams): FluentBuilder
        /**
         * The name of the proxy session.
         */
        fun name(name: String): FluentBuilder
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        fun numberSelectionBehavior(numberSelectionBehavior: NumberSelectionBehavior): FluentBuilder
        /**
         * The proxy session participants.
         */
        fun participants(participants: List<Participant>): FluentBuilder
        /**
         * The proxy session ID.
         */
        fun proxySessionId(proxySessionId: String): FluentBuilder
        /**
         * The status of the proxy session.
         */
        fun status(status: ProxySessionStatus): FluentBuilder
        /**
         * The updated time stamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
        /**
         * The Amazon Chime voice connector ID.
         */
        fun voiceConnectorId(voiceConnectorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The proxy session capabilities.
         */
        var capabilities: List<Capability>?
        /**
         * The created time stamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The ended time stamp, in ISO 8601 format.
         */
        var endedTimestamp: Instant?
        /**
         * The number of minutes allowed for the proxy session.
         */
        var expiryMinutes: Int?
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        var geoMatchLevel: GeoMatchLevel?
        /**
         * The country and area code for the proxy phone number.
         */
        var geoMatchParams: GeoMatchParams?
        /**
         * The name of the proxy session.
         */
        var name: String?
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        var numberSelectionBehavior: NumberSelectionBehavior?
        /**
         * The proxy session participants.
         */
        var participants: List<Participant>?
        /**
         * The proxy session ID.
         */
        var proxySessionId: String?
        /**
         * The status of the proxy session.
         */
        var status: ProxySessionStatus?
        /**
         * The updated time stamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?
        /**
         * The Amazon Chime voice connector ID.
         */
        var voiceConnectorId: String?

        fun build(): ProxySession
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.GeoMatchParams] inside the given [block]
         */
        fun geoMatchParams(block: GeoMatchParams.DslBuilder.() -> kotlin.Unit) {
            this.geoMatchParams = GeoMatchParams.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capabilities: List<Capability>? = null
        override var createdTimestamp: Instant? = null
        override var endedTimestamp: Instant? = null
        override var expiryMinutes: Int? = null
        override var geoMatchLevel: GeoMatchLevel? = null
        override var geoMatchParams: GeoMatchParams? = null
        override var name: String? = null
        override var numberSelectionBehavior: NumberSelectionBehavior? = null
        override var participants: List<Participant>? = null
        override var proxySessionId: String? = null
        override var status: ProxySessionStatus? = null
        override var updatedTimestamp: Instant? = null
        override var voiceConnectorId: String? = null

        constructor(x: ProxySession) : this() {
            this.capabilities = x.capabilities
            this.createdTimestamp = x.createdTimestamp
            this.endedTimestamp = x.endedTimestamp
            this.expiryMinutes = x.expiryMinutes
            this.geoMatchLevel = x.geoMatchLevel
            this.geoMatchParams = x.geoMatchParams
            this.name = x.name
            this.numberSelectionBehavior = x.numberSelectionBehavior
            this.participants = x.participants
            this.proxySessionId = x.proxySessionId
            this.status = x.status
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorId = x.voiceConnectorId
        }

        override fun build(): ProxySession = ProxySession(this)
        override fun capabilities(capabilities: List<Capability>): FluentBuilder = apply { this.capabilities = capabilities }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun endedTimestamp(endedTimestamp: Instant): FluentBuilder = apply { this.endedTimestamp = endedTimestamp }
        override fun expiryMinutes(expiryMinutes: Int): FluentBuilder = apply { this.expiryMinutes = expiryMinutes }
        override fun geoMatchLevel(geoMatchLevel: GeoMatchLevel): FluentBuilder = apply { this.geoMatchLevel = geoMatchLevel }
        override fun geoMatchParams(geoMatchParams: GeoMatchParams): FluentBuilder = apply { this.geoMatchParams = geoMatchParams }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun numberSelectionBehavior(numberSelectionBehavior: NumberSelectionBehavior): FluentBuilder = apply { this.numberSelectionBehavior = numberSelectionBehavior }
        override fun participants(participants: List<Participant>): FluentBuilder = apply { this.participants = participants }
        override fun proxySessionId(proxySessionId: String): FluentBuilder = apply { this.proxySessionId = proxySessionId }
        override fun status(status: ProxySessionStatus): FluentBuilder = apply { this.status = status }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
        override fun voiceConnectorId(voiceConnectorId: String): FluentBuilder = apply { this.voiceConnectorId = voiceConnectorId }
    }
}
