// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime chat room details.
 */
class Room private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime account ID.
     */
    val accountId: String? = builder.accountId
    /**
     * The identifier of the room creator.
     */
    val createdBy: String? = builder.createdBy
    /**
     * The room creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The room name.
     */
    val name: String? = builder.name
    /**
     * The room ID.
     */
    val roomId: String? = builder.roomId
    /**
     * The room update timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Room = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Room(")
        append("accountId=$accountId,")
        append("createdBy=$createdBy,")
        append("createdTimestamp=$createdTimestamp,")
        append("name=*** Sensitive Data Redacted ***,")
        append("roomId=$roomId,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roomId?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Room

        if (accountId != other.accountId) return false
        if (createdBy != other.createdBy) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false
        if (roomId != other.roomId) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Room = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Room
        /**
         * The Amazon Chime account ID.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The identifier of the room creator.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * The room creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The room name.
         */
        fun name(name: String): FluentBuilder
        /**
         * The room ID.
         */
        fun roomId(roomId: String): FluentBuilder
        /**
         * The room update timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime account ID.
         */
        var accountId: String?
        /**
         * The identifier of the room creator.
         */
        var createdBy: String?
        /**
         * The room creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The room name.
         */
        var name: String?
        /**
         * The room ID.
         */
        var roomId: String?
        /**
         * The room update timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): Room
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var createdBy: String? = null
        override var createdTimestamp: Instant? = null
        override var name: String? = null
        override var roomId: String? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: Room) : this() {
            this.accountId = x.accountId
            this.createdBy = x.createdBy
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
            this.roomId = x.roomId
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): Room = Room(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun roomId(roomId: String): FluentBuilder = apply { this.roomId = roomId }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
