// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The room membership details.
 */
class RoomMembership private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the user that invited the room member.
     */
    val invitedBy: String? = builder.invitedBy
    /**
     * The member details, such as email address, name, member ID, and member type.
     */
    val member: Member? = builder.member
    /**
     * The membership role.
     */
    val role: RoomMembershipRole? = builder.role
    /**
     * The room ID.
     */
    val roomId: String? = builder.roomId
    /**
     * The room membership update timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RoomMembership = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RoomMembership(")
        append("invitedBy=$invitedBy,")
        append("member=$member,")
        append("role=$role,")
        append("roomId=$roomId,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = invitedBy?.hashCode() ?: 0
        result = 31 * result + (member?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (roomId?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RoomMembership

        if (invitedBy != other.invitedBy) return false
        if (member != other.member) return false
        if (role != other.role) return false
        if (roomId != other.roomId) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RoomMembership = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RoomMembership
        /**
         * The identifier of the user that invited the room member.
         */
        fun invitedBy(invitedBy: String): FluentBuilder
        /**
         * The member details, such as email address, name, member ID, and member type.
         */
        fun member(member: Member): FluentBuilder
        /**
         * The membership role.
         */
        fun role(role: RoomMembershipRole): FluentBuilder
        /**
         * The room ID.
         */
        fun roomId(roomId: String): FluentBuilder
        /**
         * The room membership update timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the user that invited the room member.
         */
        var invitedBy: String?
        /**
         * The member details, such as email address, name, member ID, and member type.
         */
        var member: Member?
        /**
         * The membership role.
         */
        var role: RoomMembershipRole?
        /**
         * The room ID.
         */
        var roomId: String?
        /**
         * The room membership update timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): RoomMembership
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Member] inside the given [block]
         */
        fun member(block: Member.DslBuilder.() -> kotlin.Unit) {
            this.member = Member.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var invitedBy: String? = null
        override var member: Member? = null
        override var role: RoomMembershipRole? = null
        override var roomId: String? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: RoomMembership) : this() {
            this.invitedBy = x.invitedBy
            this.member = x.member
            this.role = x.role
            this.roomId = x.roomId
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): RoomMembership = RoomMembership(this)
        override fun invitedBy(invitedBy: String): FluentBuilder = apply { this.invitedBy = invitedBy }
        override fun member(member: Member): FluentBuilder = apply { this.member = member }
        override fun role(role: RoomMembershipRole): FluentBuilder = apply { this.role = role }
        override fun roomId(roomId: String): FluentBuilder = apply { this.roomId = roomId }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
