// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.
 */
class SipMediaApplication private constructor(builder: BuilderImpl) {
    /**
     * The AWS Region in which the SIP media application is created.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * The SIP media application creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
     */
    val endpoints: List<SipMediaApplicationEndpoint>? = builder.endpoints
    /**
     * The name of the SIP media application.
     */
    val name: String? = builder.name
    /**
     * The SIP media application ID.
     */
    val sipMediaApplicationId: String? = builder.sipMediaApplicationId
    /**
     * The SIP media application updated timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SipMediaApplication = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SipMediaApplication(")
        append("awsRegion=$awsRegion,")
        append("createdTimestamp=$createdTimestamp,")
        append("endpoints=$endpoints,")
        append("name=$name,")
        append("sipMediaApplicationId=$sipMediaApplicationId,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sipMediaApplicationId?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SipMediaApplication

        if (awsRegion != other.awsRegion) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (endpoints != other.endpoints) return false
        if (name != other.name) return false
        if (sipMediaApplicationId != other.sipMediaApplicationId) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SipMediaApplication = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SipMediaApplication
        /**
         * The AWS Region in which the SIP media application is created.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * The SIP media application creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
         */
        fun endpoints(endpoints: List<SipMediaApplicationEndpoint>): FluentBuilder
        /**
         * The name of the SIP media application.
         */
        fun name(name: String): FluentBuilder
        /**
         * The SIP media application ID.
         */
        fun sipMediaApplicationId(sipMediaApplicationId: String): FluentBuilder
        /**
         * The SIP media application updated timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AWS Region in which the SIP media application is created.
         */
        var awsRegion: String?
        /**
         * The SIP media application creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
         */
        var endpoints: List<SipMediaApplicationEndpoint>?
        /**
         * The name of the SIP media application.
         */
        var name: String?
        /**
         * The SIP media application ID.
         */
        var sipMediaApplicationId: String?
        /**
         * The SIP media application updated timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): SipMediaApplication
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsRegion: String? = null
        override var createdTimestamp: Instant? = null
        override var endpoints: List<SipMediaApplicationEndpoint>? = null
        override var name: String? = null
        override var sipMediaApplicationId: String? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: SipMediaApplication) : this() {
            this.awsRegion = x.awsRegion
            this.createdTimestamp = x.createdTimestamp
            this.endpoints = x.endpoints
            this.name = x.name
            this.sipMediaApplicationId = x.sipMediaApplicationId
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): SipMediaApplication = SipMediaApplication(this)
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun endpoints(endpoints: List<SipMediaApplicationEndpoint>): FluentBuilder = apply { this.endpoints = endpoints }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun sipMediaApplicationId(sipMediaApplicationId: String): FluentBuilder = apply { this.sipMediaApplicationId = sipMediaApplicationId }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
