// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The SIP rule details, including name, triggers, and target applications. An AWS account can have multiple SIP rules.
 */
class SipRule private constructor(builder: BuilderImpl) {
    /**
     * The time at which the SIP rule was created, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.
     */
    val disabled: Boolean? = builder.disabled
    /**
     * The name of the SIP rule.
     */
    val name: String? = builder.name
    /**
     * The SIP rule ID.
     */
    val sipRuleId: String? = builder.sipRuleId
    /**
     * Target SIP media application and other details, such as priority and AWS Region, to be
     * specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
     */
    val targetApplications: List<SipRuleTargetApplication>? = builder.targetApplications
    /**
     * The type of trigger assigned to the SIP rule in TriggerValue, currently RequestUriHostname or
     * ToPhoneNumber.
     */
    val triggerType: SipRuleTriggerType? = builder.triggerType
    /**
     * If TriggerType is RequestUriHostname, then the value can be the
     * outbound host name of the Amazon Chime Voice Connector. If TriggerType is
     * ToPhoneNumber, then the value can be a customer-owned phone number in
     * E164 format. SipRule is triggered when a SIP rule requests host name or
     * ToPhoneNumber matches in the incoming SIP request.
     */
    val triggerValue: String? = builder.triggerValue
    /**
     * The time at which the SIP rule was last updated, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SipRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SipRule(")
        append("createdTimestamp=$createdTimestamp,")
        append("disabled=$disabled,")
        append("name=$name,")
        append("sipRuleId=$sipRuleId,")
        append("targetApplications=$targetApplications,")
        append("triggerType=$triggerType,")
        append("triggerValue=$triggerValue,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sipRuleId?.hashCode() ?: 0)
        result = 31 * result + (targetApplications?.hashCode() ?: 0)
        result = 31 * result + (triggerType?.hashCode() ?: 0)
        result = 31 * result + (triggerValue?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SipRule

        if (createdTimestamp != other.createdTimestamp) return false
        if (disabled != other.disabled) return false
        if (name != other.name) return false
        if (sipRuleId != other.sipRuleId) return false
        if (targetApplications != other.targetApplications) return false
        if (triggerType != other.triggerType) return false
        if (triggerValue != other.triggerValue) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SipRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SipRule
        /**
         * The time at which the SIP rule was created, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.
         */
        fun disabled(disabled: Boolean): FluentBuilder
        /**
         * The name of the SIP rule.
         */
        fun name(name: String): FluentBuilder
        /**
         * The SIP rule ID.
         */
        fun sipRuleId(sipRuleId: String): FluentBuilder
        /**
         * Target SIP media application and other details, such as priority and AWS Region, to be
         * specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
         */
        fun targetApplications(targetApplications: List<SipRuleTargetApplication>): FluentBuilder
        /**
         * The type of trigger assigned to the SIP rule in TriggerValue, currently RequestUriHostname or
         * ToPhoneNumber.
         */
        fun triggerType(triggerType: SipRuleTriggerType): FluentBuilder
        /**
         * If TriggerType is RequestUriHostname, then the value can be the
         * outbound host name of the Amazon Chime Voice Connector. If TriggerType is
         * ToPhoneNumber, then the value can be a customer-owned phone number in
         * E164 format. SipRule is triggered when a SIP rule requests host name or
         * ToPhoneNumber matches in the incoming SIP request.
         */
        fun triggerValue(triggerValue: String): FluentBuilder
        /**
         * The time at which the SIP rule was last updated, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time at which the SIP rule was created, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.
         */
        var disabled: Boolean?
        /**
         * The name of the SIP rule.
         */
        var name: String?
        /**
         * The SIP rule ID.
         */
        var sipRuleId: String?
        /**
         * Target SIP media application and other details, such as priority and AWS Region, to be
         * specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
         */
        var targetApplications: List<SipRuleTargetApplication>?
        /**
         * The type of trigger assigned to the SIP rule in TriggerValue, currently RequestUriHostname or
         * ToPhoneNumber.
         */
        var triggerType: SipRuleTriggerType?
        /**
         * If TriggerType is RequestUriHostname, then the value can be the
         * outbound host name of the Amazon Chime Voice Connector. If TriggerType is
         * ToPhoneNumber, then the value can be a customer-owned phone number in
         * E164 format. SipRule is triggered when a SIP rule requests host name or
         * ToPhoneNumber matches in the incoming SIP request.
         */
        var triggerValue: String?
        /**
         * The time at which the SIP rule was last updated, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?

        fun build(): SipRule
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTimestamp: Instant? = null
        override var disabled: Boolean? = null
        override var name: String? = null
        override var sipRuleId: String? = null
        override var targetApplications: List<SipRuleTargetApplication>? = null
        override var triggerType: SipRuleTriggerType? = null
        override var triggerValue: String? = null
        override var updatedTimestamp: Instant? = null

        constructor(x: SipRule) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.disabled = x.disabled
            this.name = x.name
            this.sipRuleId = x.sipRuleId
            this.targetApplications = x.targetApplications
            this.triggerType = x.triggerType
            this.triggerValue = x.triggerValue
            this.updatedTimestamp = x.updatedTimestamp
        }

        override fun build(): SipRule = SipRule(this)
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun disabled(disabled: Boolean): FluentBuilder = apply { this.disabled = disabled }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun sipRuleId(sipRuleId: String): FluentBuilder = apply { this.sipRuleId = sipRuleId }
        override fun targetApplications(targetApplications: List<SipRuleTargetApplication>): FluentBuilder = apply { this.targetApplications = targetApplications }
        override fun triggerType(triggerType: SipRuleTriggerType): FluentBuilder = apply { this.triggerType = triggerType }
        override fun triggerValue(triggerValue: String): FluentBuilder = apply { this.triggerValue = triggerValue }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
    }
}
