// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Target SIP media application and other details, such as priority and AWS Region, to be
 * specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
 */
class SipRuleTargetApplication private constructor(builder: BuilderImpl) {
    /**
     * The AWS Region of the target application.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * Priority of the SIP media application in the target list.
     */
    val priority: Int? = builder.priority
    /**
     * The SIP media application ID.
     */
    val sipMediaApplicationId: String? = builder.sipMediaApplicationId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SipRuleTargetApplication = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SipRuleTargetApplication(")
        append("awsRegion=$awsRegion,")
        append("priority=$priority,")
        append("sipMediaApplicationId=$sipMediaApplicationId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (sipMediaApplicationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SipRuleTargetApplication

        if (awsRegion != other.awsRegion) return false
        if (priority != other.priority) return false
        if (sipMediaApplicationId != other.sipMediaApplicationId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SipRuleTargetApplication = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SipRuleTargetApplication
        /**
         * The AWS Region of the target application.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * Priority of the SIP media application in the target list.
         */
        fun priority(priority: Int): FluentBuilder
        /**
         * The SIP media application ID.
         */
        fun sipMediaApplicationId(sipMediaApplicationId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AWS Region of the target application.
         */
        var awsRegion: String?
        /**
         * Priority of the SIP media application in the target list.
         */
        var priority: Int?
        /**
         * The SIP media application ID.
         */
        var sipMediaApplicationId: String?

        fun build(): SipRuleTargetApplication
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsRegion: String? = null
        override var priority: Int? = null
        override var sipMediaApplicationId: String? = null

        constructor(x: SipRuleTargetApplication) : this() {
            this.awsRegion = x.awsRegion
            this.priority = x.priority
            this.sipMediaApplicationId = x.sipMediaApplicationId
        }

        override fun build(): SipRuleTargetApplication = SipRuleTargetApplication(this)
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun priority(priority: Int): FluentBuilder = apply { this.priority = priority }
        override fun sipMediaApplicationId(sipMediaApplicationId: String): FluentBuilder = apply { this.sipMediaApplicationId = sipMediaApplicationId }
    }
}
