// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether
 * media streaming is enabled for sending to Amazon Kinesis, and shows the retention period
 * for the Amazon Kinesis data, in hours.
 */
class StreamingConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The retention period, in hours, for the Amazon Kinesis data.
     */
    val dataRetentionInHours: Int? = builder.dataRetentionInHours
    /**
     * When true, media streaming to Amazon Kinesis is turned off.
     */
    val disabled: Boolean? = builder.disabled
    /**
     * The streaming notification targets.
     */
    val streamingNotificationTargets: List<StreamingNotificationTarget>? = builder.streamingNotificationTargets

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamingConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingConfiguration(")
        append("dataRetentionInHours=$dataRetentionInHours,")
        append("disabled=$disabled,")
        append("streamingNotificationTargets=$streamingNotificationTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRetentionInHours ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (streamingNotificationTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamingConfiguration

        if (dataRetentionInHours != other.dataRetentionInHours) return false
        if (disabled != other.disabled) return false
        if (streamingNotificationTargets != other.streamingNotificationTargets) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamingConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamingConfiguration
        /**
         * The retention period, in hours, for the Amazon Kinesis data.
         */
        fun dataRetentionInHours(dataRetentionInHours: Int): FluentBuilder
        /**
         * When true, media streaming to Amazon Kinesis is turned off.
         */
        fun disabled(disabled: Boolean): FluentBuilder
        /**
         * The streaming notification targets.
         */
        fun streamingNotificationTargets(streamingNotificationTargets: List<StreamingNotificationTarget>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The retention period, in hours, for the Amazon Kinesis data.
         */
        var dataRetentionInHours: Int?
        /**
         * When true, media streaming to Amazon Kinesis is turned off.
         */
        var disabled: Boolean?
        /**
         * The streaming notification targets.
         */
        var streamingNotificationTargets: List<StreamingNotificationTarget>?

        fun build(): StreamingConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataRetentionInHours: Int? = null
        override var disabled: Boolean? = null
        override var streamingNotificationTargets: List<StreamingNotificationTarget>? = null

        constructor(x: StreamingConfiguration) : this() {
            this.dataRetentionInHours = x.dataRetentionInHours
            this.disabled = x.disabled
            this.streamingNotificationTargets = x.streamingNotificationTargets
        }

        override fun build(): StreamingConfiguration = StreamingConfiguration(this)
        override fun dataRetentionInHours(dataRetentionInHours: Int): FluentBuilder = apply { this.dataRetentionInHours = dataRetentionInHours }
        override fun disabled(disabled: Boolean): FluentBuilder = apply { this.disabled = disabled }
        override fun streamingNotificationTargets(streamingNotificationTargets: List<StreamingNotificationTarget>): FluentBuilder = apply { this.streamingNotificationTargets = streamingNotificationTargets }
    }
}
