// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Settings that allow management of telephony permissions for an Amazon Chime user, such as
 * inbound and outbound calling and text messaging.
 */
class TelephonySettings private constructor(builder: BuilderImpl) {
    /**
     * Allows or denies inbound calling.
     */
    val inboundCalling: Boolean? = builder.inboundCalling
    /**
     * Allows or denies outbound calling.
     */
    val outboundCalling: Boolean? = builder.outboundCalling
    /**
     * Allows or denies SMS messaging.
     */
    val sms: Boolean? = builder.sms

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TelephonySettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TelephonySettings(")
        append("inboundCalling=$inboundCalling,")
        append("outboundCalling=$outboundCalling,")
        append("sms=$sms)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inboundCalling?.hashCode() ?: 0
        result = 31 * result + (outboundCalling?.hashCode() ?: 0)
        result = 31 * result + (sms?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TelephonySettings

        if (inboundCalling != other.inboundCalling) return false
        if (outboundCalling != other.outboundCalling) return false
        if (sms != other.sms) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TelephonySettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TelephonySettings
        /**
         * Allows or denies inbound calling.
         */
        fun inboundCalling(inboundCalling: Boolean): FluentBuilder
        /**
         * Allows or denies outbound calling.
         */
        fun outboundCalling(outboundCalling: Boolean): FluentBuilder
        /**
         * Allows or denies SMS messaging.
         */
        fun sms(sms: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Allows or denies inbound calling.
         */
        var inboundCalling: Boolean?
        /**
         * Allows or denies outbound calling.
         */
        var outboundCalling: Boolean?
        /**
         * Allows or denies SMS messaging.
         */
        var sms: Boolean?

        fun build(): TelephonySettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var inboundCalling: Boolean? = null
        override var outboundCalling: Boolean? = null
        override var sms: Boolean? = null

        constructor(x: TelephonySettings) : this() {
            this.inboundCalling = x.inboundCalling
            this.outboundCalling = x.outboundCalling
            this.sms = x.sms
        }

        override fun build(): TelephonySettings = TelephonySettings(this)
        override fun inboundCalling(inboundCalling: Boolean): FluentBuilder = apply { this.inboundCalling = inboundCalling }
        override fun outboundCalling(outboundCalling: Boolean): FluentBuilder = apply { this.outboundCalling = outboundCalling }
        override fun sms(sms: Boolean): FluentBuilder = apply { this.sms = sms }
    }
}
