// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime
 * Voice Connector.
 */
class Termination private constructor(builder: BuilderImpl) {
    /**
     * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
     */
    val callingRegions: List<String>? = builder.callingRegions
    /**
     * The IP addresses allowed to make calls, in CIDR format. Required.
     */
    val cidrAllowedList: List<String>? = builder.cidrAllowedList
    /**
     * The limit on calls per second. Max value based on account service quota. Default value of
     * 1.
     */
    val cpsLimit: Int? = builder.cpsLimit
    /**
     * The default caller ID phone number.
     */
    val defaultPhoneNumber: String? = builder.defaultPhoneNumber
    /**
     * When termination settings are disabled, outbound calls can not be made.
     */
    val disabled: Boolean? = builder.disabled

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Termination = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Termination(")
        append("callingRegions=$callingRegions,")
        append("cidrAllowedList=$cidrAllowedList,")
        append("cpsLimit=$cpsLimit,")
        append("defaultPhoneNumber=*** Sensitive Data Redacted ***,")
        append("disabled=$disabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callingRegions?.hashCode() ?: 0
        result = 31 * result + (cidrAllowedList?.hashCode() ?: 0)
        result = 31 * result + (cpsLimit ?: 0)
        result = 31 * result + (defaultPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (disabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Termination

        if (callingRegions != other.callingRegions) return false
        if (cidrAllowedList != other.cidrAllowedList) return false
        if (cpsLimit != other.cpsLimit) return false
        if (defaultPhoneNumber != other.defaultPhoneNumber) return false
        if (disabled != other.disabled) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Termination = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Termination
        /**
         * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         */
        fun callingRegions(callingRegions: List<String>): FluentBuilder
        /**
         * The IP addresses allowed to make calls, in CIDR format. Required.
         */
        fun cidrAllowedList(cidrAllowedList: List<String>): FluentBuilder
        /**
         * The limit on calls per second. Max value based on account service quota. Default value of
         * 1.
         */
        fun cpsLimit(cpsLimit: Int): FluentBuilder
        /**
         * The default caller ID phone number.
         */
        fun defaultPhoneNumber(defaultPhoneNumber: String): FluentBuilder
        /**
         * When termination settings are disabled, outbound calls can not be made.
         */
        fun disabled(disabled: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         */
        var callingRegions: List<String>?
        /**
         * The IP addresses allowed to make calls, in CIDR format. Required.
         */
        var cidrAllowedList: List<String>?
        /**
         * The limit on calls per second. Max value based on account service quota. Default value of
         * 1.
         */
        var cpsLimit: Int?
        /**
         * The default caller ID phone number.
         */
        var defaultPhoneNumber: String?
        /**
         * When termination settings are disabled, outbound calls can not be made.
         */
        var disabled: Boolean?

        fun build(): Termination
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var callingRegions: List<String>? = null
        override var cidrAllowedList: List<String>? = null
        override var cpsLimit: Int? = null
        override var defaultPhoneNumber: String? = null
        override var disabled: Boolean? = null

        constructor(x: Termination) : this() {
            this.callingRegions = x.callingRegions
            this.cidrAllowedList = x.cidrAllowedList
            this.cpsLimit = x.cpsLimit
            this.defaultPhoneNumber = x.defaultPhoneNumber
            this.disabled = x.disabled
        }

        override fun build(): Termination = Termination(this)
        override fun callingRegions(callingRegions: List<String>): FluentBuilder = apply { this.callingRegions = callingRegions }
        override fun cidrAllowedList(cidrAllowedList: List<String>): FluentBuilder = apply { this.cidrAllowedList = cidrAllowedList }
        override fun cpsLimit(cpsLimit: Int): FluentBuilder = apply { this.cpsLimit = cpsLimit }
        override fun defaultPhoneNumber(defaultPhoneNumber: String): FluentBuilder = apply { this.defaultPhoneNumber = defaultPhoneNumber }
        override fun disabled(disabled: Boolean): FluentBuilder = apply { this.disabled = disabled }
    }
}
