// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The user on the Amazon Chime account.
 */
class User private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime account ID.
     */
    val accountId: String? = builder.accountId
    /**
     * The Alexa for Business metadata.
     */
    val alexaForBusinessMetadata: AlexaForBusinessMetadata? = builder.alexaForBusinessMetadata
    /**
     * The display name of the user.
     */
    val displayName: String? = builder.displayName
    /**
     * Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
     */
    val invitedOn: Instant? = builder.invitedOn
    /**
     * The license type for the user.
     */
    val licenseType: License? = builder.licenseType
    /**
     * The user's personal meeting PIN.
     */
    val personalPin: String? = builder.personalPin
    /**
     * The primary email address of the user.
     */
    val primaryEmail: String? = builder.primaryEmail
    /**
     * The primary phone number associated with the user.
     */
    val primaryProvisionedNumber: String? = builder.primaryProvisionedNumber
    /**
     * Date and time when the user is registered, in ISO 8601 format.
     */
    val registeredOn: Instant? = builder.registeredOn
    /**
     * The user ID.
     */
    val userId: String? = builder.userId
    /**
     * The user invite status.
     */
    val userInvitationStatus: InviteStatus? = builder.userInvitationStatus
    /**
     * The user registration status.
     */
    val userRegistrationStatus: RegistrationStatus? = builder.userRegistrationStatus
    /**
     * The user type.
     */
    val userType: UserType? = builder.userType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): User = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("accountId=$accountId,")
        append("alexaForBusinessMetadata=$alexaForBusinessMetadata,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("invitedOn=$invitedOn,")
        append("licenseType=$licenseType,")
        append("personalPin=$personalPin,")
        append("primaryEmail=*** Sensitive Data Redacted ***,")
        append("primaryProvisionedNumber=*** Sensitive Data Redacted ***,")
        append("registeredOn=$registeredOn,")
        append("userId=$userId,")
        append("userInvitationStatus=$userInvitationStatus,")
        append("userRegistrationStatus=$userRegistrationStatus,")
        append("userType=$userType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alexaForBusinessMetadata?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (invitedOn?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (personalPin?.hashCode() ?: 0)
        result = 31 * result + (primaryEmail?.hashCode() ?: 0)
        result = 31 * result + (primaryProvisionedNumber?.hashCode() ?: 0)
        result = 31 * result + (registeredOn?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userInvitationStatus?.hashCode() ?: 0)
        result = 31 * result + (userRegistrationStatus?.hashCode() ?: 0)
        result = 31 * result + (userType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as User

        if (accountId != other.accountId) return false
        if (alexaForBusinessMetadata != other.alexaForBusinessMetadata) return false
        if (displayName != other.displayName) return false
        if (invitedOn != other.invitedOn) return false
        if (licenseType != other.licenseType) return false
        if (personalPin != other.personalPin) return false
        if (primaryEmail != other.primaryEmail) return false
        if (primaryProvisionedNumber != other.primaryProvisionedNumber) return false
        if (registeredOn != other.registeredOn) return false
        if (userId != other.userId) return false
        if (userInvitationStatus != other.userInvitationStatus) return false
        if (userRegistrationStatus != other.userRegistrationStatus) return false
        if (userType != other.userType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): User = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): User
        /**
         * The Amazon Chime account ID.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Alexa for Business metadata.
         */
        fun alexaForBusinessMetadata(alexaForBusinessMetadata: AlexaForBusinessMetadata): FluentBuilder
        /**
         * The display name of the user.
         */
        fun displayName(displayName: String): FluentBuilder
        /**
         * Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
         */
        fun invitedOn(invitedOn: Instant): FluentBuilder
        /**
         * The license type for the user.
         */
        fun licenseType(licenseType: License): FluentBuilder
        /**
         * The user's personal meeting PIN.
         */
        fun personalPin(personalPin: String): FluentBuilder
        /**
         * The primary email address of the user.
         */
        fun primaryEmail(primaryEmail: String): FluentBuilder
        /**
         * The primary phone number associated with the user.
         */
        fun primaryProvisionedNumber(primaryProvisionedNumber: String): FluentBuilder
        /**
         * Date and time when the user is registered, in ISO 8601 format.
         */
        fun registeredOn(registeredOn: Instant): FluentBuilder
        /**
         * The user ID.
         */
        fun userId(userId: String): FluentBuilder
        /**
         * The user invite status.
         */
        fun userInvitationStatus(userInvitationStatus: InviteStatus): FluentBuilder
        /**
         * The user registration status.
         */
        fun userRegistrationStatus(userRegistrationStatus: RegistrationStatus): FluentBuilder
        /**
         * The user type.
         */
        fun userType(userType: UserType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime account ID.
         */
        var accountId: String?
        /**
         * The Alexa for Business metadata.
         */
        var alexaForBusinessMetadata: AlexaForBusinessMetadata?
        /**
         * The display name of the user.
         */
        var displayName: String?
        /**
         * Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.
         */
        var invitedOn: Instant?
        /**
         * The license type for the user.
         */
        var licenseType: License?
        /**
         * The user's personal meeting PIN.
         */
        var personalPin: String?
        /**
         * The primary email address of the user.
         */
        var primaryEmail: String?
        /**
         * The primary phone number associated with the user.
         */
        var primaryProvisionedNumber: String?
        /**
         * Date and time when the user is registered, in ISO 8601 format.
         */
        var registeredOn: Instant?
        /**
         * The user ID.
         */
        var userId: String?
        /**
         * The user invite status.
         */
        var userInvitationStatus: InviteStatus?
        /**
         * The user registration status.
         */
        var userRegistrationStatus: RegistrationStatus?
        /**
         * The user type.
         */
        var userType: UserType?

        fun build(): User
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.AlexaForBusinessMetadata] inside the given [block]
         */
        fun alexaForBusinessMetadata(block: AlexaForBusinessMetadata.DslBuilder.() -> kotlin.Unit) {
            this.alexaForBusinessMetadata = AlexaForBusinessMetadata.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var alexaForBusinessMetadata: AlexaForBusinessMetadata? = null
        override var displayName: String? = null
        override var invitedOn: Instant? = null
        override var licenseType: License? = null
        override var personalPin: String? = null
        override var primaryEmail: String? = null
        override var primaryProvisionedNumber: String? = null
        override var registeredOn: Instant? = null
        override var userId: String? = null
        override var userInvitationStatus: InviteStatus? = null
        override var userRegistrationStatus: RegistrationStatus? = null
        override var userType: UserType? = null

        constructor(x: User) : this() {
            this.accountId = x.accountId
            this.alexaForBusinessMetadata = x.alexaForBusinessMetadata
            this.displayName = x.displayName
            this.invitedOn = x.invitedOn
            this.licenseType = x.licenseType
            this.personalPin = x.personalPin
            this.primaryEmail = x.primaryEmail
            this.primaryProvisionedNumber = x.primaryProvisionedNumber
            this.registeredOn = x.registeredOn
            this.userId = x.userId
            this.userInvitationStatus = x.userInvitationStatus
            this.userRegistrationStatus = x.userRegistrationStatus
            this.userType = x.userType
        }

        override fun build(): User = User(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun alexaForBusinessMetadata(alexaForBusinessMetadata: AlexaForBusinessMetadata): FluentBuilder = apply { this.alexaForBusinessMetadata = alexaForBusinessMetadata }
        override fun displayName(displayName: String): FluentBuilder = apply { this.displayName = displayName }
        override fun invitedOn(invitedOn: Instant): FluentBuilder = apply { this.invitedOn = invitedOn }
        override fun licenseType(licenseType: License): FluentBuilder = apply { this.licenseType = licenseType }
        override fun personalPin(personalPin: String): FluentBuilder = apply { this.personalPin = personalPin }
        override fun primaryEmail(primaryEmail: String): FluentBuilder = apply { this.primaryEmail = primaryEmail }
        override fun primaryProvisionedNumber(primaryProvisionedNumber: String): FluentBuilder = apply { this.primaryProvisionedNumber = primaryProvisionedNumber }
        override fun registeredOn(registeredOn: Instant): FluentBuilder = apply { this.registeredOn = registeredOn }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
        override fun userInvitationStatus(userInvitationStatus: InviteStatus): FluentBuilder = apply { this.userInvitationStatus = userInvitationStatus }
        override fun userRegistrationStatus(userRegistrationStatus: RegistrationStatus): FluentBuilder = apply { this.userRegistrationStatus = userRegistrationStatus }
        override fun userType(userType: UserType): FluentBuilder = apply { this.userType = userType }
    }
}
