// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime Voice Connector configuration, including outbound host name and encryption
 * settings.
 */
class VoiceConnector private constructor(builder: BuilderImpl) {
    /**
     * The AWS Region in which the Amazon Chime Voice Connector is created. Default:
     * us-east-1.
     */
    val awsRegion: VoiceConnectorAwsRegion? = builder.awsRegion
    /**
     * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The name of the Amazon Chime Voice Connector.
     */
    val name: String? = builder.name
    /**
     * The outbound host name for the Amazon Chime Voice Connector.
     */
    val outboundHostName: String? = builder.outboundHostName
    /**
     * Designates whether encryption is required for the Amazon Chime Voice Connector.
     */
    val requireEncryption: Boolean? = builder.requireEncryption
    /**
     * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp
    /**
     * The Amazon Chime Voice Connector ID.
     */
    val voiceConnectorId: String? = builder.voiceConnectorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VoiceConnector = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceConnector(")
        append("awsRegion=$awsRegion,")
        append("createdTimestamp=$createdTimestamp,")
        append("name=$name,")
        append("outboundHostName=$outboundHostName,")
        append("requireEncryption=$requireEncryption,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outboundHostName?.hashCode() ?: 0)
        result = 31 * result + (requireEncryption?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VoiceConnector

        if (awsRegion != other.awsRegion) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false
        if (outboundHostName != other.outboundHostName) return false
        if (requireEncryption != other.requireEncryption) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VoiceConnector = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VoiceConnector
        /**
         * The AWS Region in which the Amazon Chime Voice Connector is created. Default:
         * us-east-1.
         */
        fun awsRegion(awsRegion: VoiceConnectorAwsRegion): FluentBuilder
        /**
         * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The name of the Amazon Chime Voice Connector.
         */
        fun name(name: String): FluentBuilder
        /**
         * The outbound host name for the Amazon Chime Voice Connector.
         */
        fun outboundHostName(outboundHostName: String): FluentBuilder
        /**
         * Designates whether encryption is required for the Amazon Chime Voice Connector.
         */
        fun requireEncryption(requireEncryption: Boolean): FluentBuilder
        /**
         * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
        /**
         * The Amazon Chime Voice Connector ID.
         */
        fun voiceConnectorId(voiceConnectorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AWS Region in which the Amazon Chime Voice Connector is created. Default:
         * us-east-1.
         */
        var awsRegion: VoiceConnectorAwsRegion?
        /**
         * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The name of the Amazon Chime Voice Connector.
         */
        var name: String?
        /**
         * The outbound host name for the Amazon Chime Voice Connector.
         */
        var outboundHostName: String?
        /**
         * Designates whether encryption is required for the Amazon Chime Voice Connector.
         */
        var requireEncryption: Boolean?
        /**
         * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?
        /**
         * The Amazon Chime Voice Connector ID.
         */
        var voiceConnectorId: String?

        fun build(): VoiceConnector
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsRegion: VoiceConnectorAwsRegion? = null
        override var createdTimestamp: Instant? = null
        override var name: String? = null
        override var outboundHostName: String? = null
        override var requireEncryption: Boolean? = null
        override var updatedTimestamp: Instant? = null
        override var voiceConnectorId: String? = null

        constructor(x: VoiceConnector) : this() {
            this.awsRegion = x.awsRegion
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
            this.outboundHostName = x.outboundHostName
            this.requireEncryption = x.requireEncryption
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorId = x.voiceConnectorId
        }

        override fun build(): VoiceConnector = VoiceConnector(this)
        override fun awsRegion(awsRegion: VoiceConnectorAwsRegion): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun outboundHostName(outboundHostName: String): FluentBuilder = apply { this.outboundHostName = outboundHostName }
        override fun requireEncryption(requireEncryption: Boolean): FluentBuilder = apply { this.requireEncryption = requireEncryption }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
        override fun voiceConnectorId(voiceConnectorId: String): FluentBuilder = apply { this.voiceConnectorId = voiceConnectorId }
    }
}
