// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice
 * Connectors. You can include Amazon Chime Voice Connectors from different AWS Regions in
 * your group. This creates a fault tolerant mechanism for fallback in case of availability
 * events.
 */
class VoiceConnectorGroup private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The name of the Amazon Chime Voice Connector group.
     */
    val name: String? = builder.name
    /**
     * The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp
    /**
     * The Amazon Chime Voice Connector group ID.
     */
    val voiceConnectorGroupId: String? = builder.voiceConnectorGroupId
    /**
     * The Amazon Chime Voice Connectors to which to route inbound calls.
     */
    val voiceConnectorItems: List<VoiceConnectorItem>? = builder.voiceConnectorItems

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VoiceConnectorGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceConnectorGroup(")
        append("createdTimestamp=$createdTimestamp,")
        append("name=$name,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorGroupId=$voiceConnectorGroupId,")
        append("voiceConnectorItems=$voiceConnectorItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorGroupId?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorItems?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VoiceConnectorGroup

        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorGroupId != other.voiceConnectorGroupId) return false
        if (voiceConnectorItems != other.voiceConnectorItems) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VoiceConnectorGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VoiceConnectorGroup
        /**
         * The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The name of the Amazon Chime Voice Connector group.
         */
        fun name(name: String): FluentBuilder
        /**
         * The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
        /**
         * The Amazon Chime Voice Connector group ID.
         */
        fun voiceConnectorGroupId(voiceConnectorGroupId: String): FluentBuilder
        /**
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         */
        fun voiceConnectorItems(voiceConnectorItems: List<VoiceConnectorItem>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The name of the Amazon Chime Voice Connector group.
         */
        var name: String?
        /**
         * The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?
        /**
         * The Amazon Chime Voice Connector group ID.
         */
        var voiceConnectorGroupId: String?
        /**
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         */
        var voiceConnectorItems: List<VoiceConnectorItem>?

        fun build(): VoiceConnectorGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdTimestamp: Instant? = null
        override var name: String? = null
        override var updatedTimestamp: Instant? = null
        override var voiceConnectorGroupId: String? = null
        override var voiceConnectorItems: List<VoiceConnectorItem>? = null

        constructor(x: VoiceConnectorGroup) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorGroupId = x.voiceConnectorGroupId
            this.voiceConnectorItems = x.voiceConnectorItems
        }

        override fun build(): VoiceConnectorGroup = VoiceConnectorGroup(this)
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
        override fun voiceConnectorGroupId(voiceConnectorGroupId: String): FluentBuilder = apply { this.voiceConnectorGroupId = voiceConnectorGroupId }
        override fun voiceConnectorItems(voiceConnectorItems: List<VoiceConnectorItem>): FluentBuilder = apply { this.voiceConnectorItems = voiceConnectorItems }
    }
}
