// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to which to route inbound calls. Includes priority configuration settings. Limit: 3
 * VoiceConnectorItems
 * per Amazon Chime Voice Connector group.
 */
class VoiceConnectorItem private constructor(builder: BuilderImpl) {
    /**
     * The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
     */
    val priority: Int? = builder.priority
    /**
     * The Amazon Chime Voice Connector ID.
     */
    val voiceConnectorId: String? = builder.voiceConnectorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VoiceConnectorItem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceConnectorItem(")
        append("priority=$priority,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority ?: 0
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VoiceConnectorItem

        if (priority != other.priority) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VoiceConnectorItem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VoiceConnectorItem
        /**
         * The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
         */
        fun priority(priority: Int): FluentBuilder
        /**
         * The Amazon Chime Voice Connector ID.
         */
        fun voiceConnectorId(voiceConnectorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.
         */
        var priority: Int?
        /**
         * The Amazon Chime Voice Connector ID.
         */
        var voiceConnectorId: String?

        fun build(): VoiceConnectorItem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var priority: Int? = null
        override var voiceConnectorId: String? = null

        constructor(x: VoiceConnectorItem) : this() {
            this.priority = x.priority
            this.voiceConnectorId = x.voiceConnectorId
        }

        override fun build(): VoiceConnectorItem = VoiceConnectorItem(this)
        override fun priority(priority: Int): FluentBuilder = apply { this.priority = priority }
        override fun voiceConnectorId(voiceConnectorId: String): FluentBuilder = apply { this.voiceConnectorId = voiceConnectorId }
    }
}
