// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorStreamingConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteVoiceConnectorStreamingConfigurationOperationDeserializer: HttpDeserialize<DeleteVoiceConnectorStreamingConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteVoiceConnectorStreamingConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDeleteVoiceConnectorStreamingConfigurationError(context, response)
        }
        val builder = DeleteVoiceConnectorStreamingConfigurationResponse.builder()

        return builder.build()
    }
}

private suspend fun throwDeleteVoiceConnectorStreamingConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer()
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer()
        else -> throw ChimeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
