// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetVoiceConnectorLoggingConfigurationOperationDeserializer: HttpDeserialize<GetVoiceConnectorLoggingConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetVoiceConnectorLoggingConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetVoiceConnectorLoggingConfigurationError(context, response)
        }
        val builder = GetVoiceConnectorLoggingConfigurationResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetVoiceConnectorLoggingConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetVoiceConnectorLoggingConfigurationOperationBody(builder: GetVoiceConnectorLoggingConfigurationResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetVoiceConnectorLoggingConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer()
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer()
        else -> throw ChimeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
