// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.sdk.kotlin.services.chime.model.UpdateSipRuleResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSipRuleOperationDeserializer: HttpDeserialize<UpdateSipRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSipRuleResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSipRuleError(context, response)
        }
        val builder = UpdateSipRuleResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSipRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateSipRuleOperationBody(builder: UpdateSipRuleResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SIPRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SipRule"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SIPRULE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SIPRULE_DESCRIPTOR.index -> builder.sipRule = deserializeSipRuleDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateSipRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer()
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer()
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer()
        else -> throw ChimeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
