// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloud9.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloud9.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Cloud9
 * Cloud9 is a collection of tools that you can use to code, build, run, test, debug, and release software in the cloud.
 *
 * For more information about Cloud9, see the [Cloud9 User Guide](https://docs.aws.amazon.com/cloud9/latest/user-guide).
 *
 * Cloud9 supports these operations:
 * + `CreateEnvironmentEC2`: Creates an Cloud9 development environment, launches an Amazon EC2 instance, and then connects from the instance to the environment.
 * + `CreateEnvironmentMembership`: Adds an environment member to an environment.
 * + `DeleteEnvironment`: Deletes an environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
 * + `DeleteEnvironmentMembership`: Deletes an environment member from an environment.
 * + `DescribeEnvironmentMemberships`: Gets information about environment members for an environment.
 * + `DescribeEnvironments`: Gets information about environments.
 * + `DescribeEnvironmentStatus`: Gets status information for an environment.
 * + `ListEnvironments`: Gets a list of environment identifiers.
 * + `ListTagsForResource`: Gets the tags for an environment.
 * + `TagResource`: Adds tags to an environment.
 * + `UntagResource`: Removes tags from an environment.
 * + `UpdateEnvironment`: Changes the settings of an existing environment.
 * + `UpdateEnvironmentMembership`: Changes the settings of an existing environment member for an environment.
 */
interface Cloud9Client : SdkClient {

    override val serviceName: String
        get() = "Cloud9"
    /**
     * Cloud9Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): Cloud9Client {
            val config = Config.Builder().apply(block).build()
            return DefaultCloud9Client(config)
        }

        operator fun invoke(config: Config): Cloud9Client = DefaultCloud9Client(config)

        /**
         * Construct a [Cloud9Client] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Cloud9Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCloud9Client(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
     */
    suspend fun createEnvironmentEc2(input: CreateEnvironmentEc2Request): CreateEnvironmentEc2Response

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
     */
    suspend fun createEnvironmentEc2(block: CreateEnvironmentEc2Request.Builder.() -> Unit) = createEnvironmentEc2(CreateEnvironmentEc2Request.Builder().apply(block).build())

    /**
     * Adds an environment member to an Cloud9 development environment.
     */
    suspend fun createEnvironmentMembership(input: CreateEnvironmentMembershipRequest): CreateEnvironmentMembershipResponse

    /**
     * Adds an environment member to an Cloud9 development environment.
     */
    suspend fun createEnvironmentMembership(block: CreateEnvironmentMembershipRequest.Builder.() -> Unit) = createEnvironmentMembership(CreateEnvironmentMembershipRequest.Builder().apply(block).build())

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
     */
    suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
     */
    suspend fun deleteEnvironment(block: DeleteEnvironmentRequest.Builder.() -> Unit) = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

    /**
     * Deletes an environment member from an Cloud9 development environment.
     */
    suspend fun deleteEnvironmentMembership(input: DeleteEnvironmentMembershipRequest): DeleteEnvironmentMembershipResponse

    /**
     * Deletes an environment member from an Cloud9 development environment.
     */
    suspend fun deleteEnvironmentMembership(block: DeleteEnvironmentMembershipRequest.Builder.() -> Unit) = deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest.Builder().apply(block).build())

    /**
     * Gets information about environment members for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentMemberships(input: DescribeEnvironmentMembershipsRequest = DescribeEnvironmentMembershipsRequest {}): DescribeEnvironmentMembershipsResponse

    /**
     * Gets information about environment members for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentMemberships(block: DescribeEnvironmentMembershipsRequest.Builder.() -> Unit) = describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.Builder().apply(block).build())

    /**
     * Gets status information for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentStatus(input: DescribeEnvironmentStatusRequest): DescribeEnvironmentStatusResponse

    /**
     * Gets status information for an Cloud9 development environment.
     */
    suspend fun describeEnvironmentStatus(block: DescribeEnvironmentStatusRequest.Builder.() -> Unit) = describeEnvironmentStatus(DescribeEnvironmentStatusRequest.Builder().apply(block).build())

    /**
     * Gets information about Cloud9 development environments.
     */
    suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse

    /**
     * Gets information about Cloud9 development environments.
     */
    suspend fun describeEnvironments(block: DescribeEnvironmentsRequest.Builder.() -> Unit) = describeEnvironments(DescribeEnvironmentsRequest.Builder().apply(block).build())

    /**
     * Gets a list of Cloud9 development environment identifiers.
     */
    suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest {}): ListEnvironmentsResponse

    /**
     * Gets a list of Cloud9 development environment identifiers.
     */
    suspend fun listEnvironments(block: ListEnvironmentsRequest.Builder.() -> Unit) = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Adds tags to an Cloud9 development environment.
     *
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to an Cloud9 development environment.
     *
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from an Cloud9 development environment.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from an Cloud9 development environment.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Changes the settings of an existing Cloud9 development environment.
     */
    suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Changes the settings of an existing Cloud9 development environment.
     */
    suspend fun updateEnvironment(block: UpdateEnvironmentRequest.Builder.() -> Unit) = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

    /**
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     */
    suspend fun updateEnvironmentMembership(input: UpdateEnvironmentMembershipRequest): UpdateEnvironmentMembershipResponse

    /**
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     */
    suspend fun updateEnvironmentMembership(block: UpdateEnvironmentMembershipRequest.Builder.() -> Unit) = updateEnvironmentMembership(UpdateEnvironmentMembershipRequest.Builder().apply(block).build())
}
