// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.model



/**
 * Information about the current creation or deletion lifecycle state of an Cloud9 development environment.
 */
class EnvironmentLifecycle private constructor(builder: Builder) {
    /**
     * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services resource.
     */
    val failureResource: kotlin.String? = builder.failureResource
    /**
     * Any informational message about the lifecycle state of the environment.
     */
    val reason: kotlin.String? = builder.reason
    /**
     * The current creation or deletion lifecycle state of the environment.
     * + `CREATING`: The environment is in the process of being created.
     * + `CREATED`: The environment was successfully created.
     * + `CREATE_FAILED`: The environment failed to be created.
     * + `DELETING`: The environment is in the process of being deleted.
     * + `DELETE_FAILED`: The environment failed to delete.
     */
    val status: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycleStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentLifecycle(")
        append("failureResource=$failureResource,")
        append("reason=$reason,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureResource?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentLifecycle

        if (failureResource != other.failureResource) return false
        if (reason != other.reason) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = Builder(this).apply(block).build()

    class Builder {
        /**
         * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services resource.
         */
        var failureResource: kotlin.String? = null
        /**
         * Any informational message about the lifecycle state of the environment.
         */
        var reason: kotlin.String? = null
        /**
         * The current creation or deletion lifecycle state of the environment.
         * + `CREATING`: The environment is in the process of being created.
         * + `CREATED`: The environment was successfully created.
         * + `CREATE_FAILED`: The environment failed to be created.
         * + `DELETING`: The environment is in the process of being deleted.
         * + `DELETE_FAILED`: The environment failed to delete.
         */
        var status: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycleStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle) : this() {
            this.failureResource = x.failureResource
            this.reason = x.reason
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloud9.model.EnvironmentLifecycle = EnvironmentLifecycle(this)
    }
}
