// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.paginators

import aws.sdk.kotlin.services.cloud9.Cloud9Client
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsResponse
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeEnvironmentMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEnvironmentMembershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEnvironmentMembershipsResponse]
 */
fun Cloud9Client.describeEnvironmentMembershipsPaginated(initialRequest: DescribeEnvironmentMembershipsRequest): Flow<DescribeEnvironmentMembershipsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEnvironmentMembershipsPaginated.describeEnvironmentMemberships(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEnvironmentMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEnvironmentMembershipsResponse]
 */
fun Cloud9Client.describeEnvironmentMembershipsPaginated(block: DescribeEnvironmentMembershipsRequest.Builder.() -> Unit): Flow<DescribeEnvironmentMembershipsResponse> =
    describeEnvironmentMembershipsPaginated(DescribeEnvironmentMembershipsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
fun Cloud9Client.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
fun Cloud9Client.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())
