// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloud9.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cloud9.model.*
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Request
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentEc2Response
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.CreateEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.cloud9.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentMembershipsResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentStatusRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentStatusResponse
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentsRequest
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentsResponse
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.cloud9.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.cloud9.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cloud9.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cloud9.model.TagResourceRequest
import aws.sdk.kotlin.services.cloud9.model.TagResourceResponse
import aws.sdk.kotlin.services.cloud9.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloud9.model.UntagResourceResponse
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentMembershipRequest
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentMembershipResponse
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.cloud9.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Cloud9
 * Cloud9 is a collection of tools that you can use to code, build, run, test, debug, and release software in the cloud.
 *
 * For more information about Cloud9, see the [Cloud9 User Guide](https://docs.aws.amazon.com/cloud9/latest/user-guide).
 *
 * Cloud9 supports these operations:
 * + `CreateEnvironmentEC2`: Creates an Cloud9 development environment, launches an Amazon EC2 instance, and then connects from the instance to the environment.
 * + `CreateEnvironmentMembership`: Adds an environment member to an environment.
 * + `DeleteEnvironment`: Deletes an environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
 * + `DeleteEnvironmentMembership`: Deletes an environment member from an environment.
 * + `DescribeEnvironmentMemberships`: Gets information about environment members for an environment.
 * + `DescribeEnvironments`: Gets information about environments.
 * + `DescribeEnvironmentStatus`: Gets status information for an environment.
 * + `ListEnvironments`: Gets a list of environment identifiers.
 * + `ListTagsForResource`: Gets the tags for an environment.
 * + `TagResource`: Adds tags to an environment.
 * + `UntagResource`: Removes tags from an environment.
 * + `UpdateEnvironment`: Changes the settings of an existing environment.
 * + `UpdateEnvironmentMembership`: Changes the settings of an existing environment member for an environment.
 */
public interface Cloud9Client : SdkClient {

    override val serviceName: String
        get() = "Cloud9"
    /**
     * Cloud9Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Cloud9Client {
            val config = Config.Builder().apply(block).build()
            return DefaultCloud9Client(config)
        }

        public operator fun invoke(config: Config): Cloud9Client = DefaultCloud9Client(config)

        /**
         * Construct a [Cloud9Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Cloud9Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCloud9Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
     */
    public suspend fun createEnvironmentEc2(input: CreateEnvironmentEc2Request): CreateEnvironmentEc2Response

    /**
     * Adds an environment member to an Cloud9 development environment.
     */
    public suspend fun createEnvironmentMembership(input: CreateEnvironmentMembershipRequest): CreateEnvironmentMembershipResponse

    /**
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes an environment member from a development environment.
     */
    public suspend fun deleteEnvironmentMembership(input: DeleteEnvironmentMembershipRequest): DeleteEnvironmentMembershipResponse

    /**
     * Gets information about environment members for an Cloud9 development environment.
     */
    public suspend fun describeEnvironmentMemberships(input: DescribeEnvironmentMembershipsRequest = DescribeEnvironmentMembershipsRequest {}): DescribeEnvironmentMembershipsResponse

    /**
     * Gets status information for an Cloud9 development environment.
     */
    public suspend fun describeEnvironmentStatus(input: DescribeEnvironmentStatusRequest): DescribeEnvironmentStatusResponse

    /**
     * Gets information about Cloud9 development environments.
     */
    public suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse

    /**
     * Gets a list of Cloud9 development environment identifiers.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest {}): ListEnvironmentsResponse

    /**
     * Gets a list of the tags associated with an Cloud9 development environment.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds tags to an Cloud9 development environment.
     *
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Cloud9 development environment.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Changes the settings of an existing Cloud9 development environment.
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     */
    public suspend fun updateEnvironmentMembership(input: UpdateEnvironmentMembershipRequest): UpdateEnvironmentMembershipResponse
}

/**
 * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
 */
public suspend inline fun Cloud9Client.createEnvironmentEc2(crossinline block: CreateEnvironmentEc2Request.Builder.() -> Unit): CreateEnvironmentEc2Response = createEnvironmentEc2(CreateEnvironmentEc2Request.Builder().apply(block).build())

/**
 * Adds an environment member to an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.createEnvironmentMembership(crossinline block: CreateEnvironmentMembershipRequest.Builder.() -> Unit): CreateEnvironmentMembershipResponse = createEnvironmentMembership(CreateEnvironmentMembershipRequest.Builder().apply(block).build())

/**
 * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
 */
public suspend inline fun Cloud9Client.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes an environment member from a development environment.
 */
public suspend inline fun Cloud9Client.deleteEnvironmentMembership(crossinline block: DeleteEnvironmentMembershipRequest.Builder.() -> Unit): DeleteEnvironmentMembershipResponse = deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest.Builder().apply(block).build())

/**
 * Gets information about environment members for an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.describeEnvironmentMemberships(crossinline block: DescribeEnvironmentMembershipsRequest.Builder.() -> Unit): DescribeEnvironmentMembershipsResponse = describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.Builder().apply(block).build())

/**
 * Gets status information for an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.describeEnvironmentStatus(crossinline block: DescribeEnvironmentStatusRequest.Builder.() -> Unit): DescribeEnvironmentStatusResponse = describeEnvironmentStatus(DescribeEnvironmentStatusRequest.Builder().apply(block).build())

/**
 * Gets information about Cloud9 development environments.
 */
public suspend inline fun Cloud9Client.describeEnvironments(crossinline block: DescribeEnvironmentsRequest.Builder.() -> Unit): DescribeEnvironmentsResponse = describeEnvironments(DescribeEnvironmentsRequest.Builder().apply(block).build())

/**
 * Gets a list of Cloud9 development environment identifiers.
 */
public suspend inline fun Cloud9Client.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Gets a list of the tags associated with an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds tags to an Cloud9 development environment.
 *
 * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to underlying resources.
 */
public suspend inline fun Cloud9Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Changes the settings of an existing Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Changes the settings of an existing environment member for an Cloud9 development environment.
 */
public suspend inline fun Cloud9Client.updateEnvironmentMembership(crossinline block: UpdateEnvironmentMembershipRequest.Builder.() -> Unit): UpdateEnvironmentMembershipResponse = updateEnvironmentMembership(UpdateEnvironmentMembershipRequest.Builder().apply(block).build())
