// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloud9.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloud9.model.Cloud9Exception
import aws.sdk.kotlin.services.cloud9.model.DescribeEnvironmentsResponse
import aws.sdk.kotlin.services.cloud9.model.Environment
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEnvironmentsOperationDeserializer: HttpDeserialize<DescribeEnvironmentsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEnvironmentsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEnvironmentsError(context, response)
        }
        val builder = DescribeEnvironmentsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEnvironmentsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEnvironmentsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Cloud9Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Cloud9Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEnvironmentsOperationBody(builder: DescribeEnvironmentsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENVIRONMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("environments"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENVIRONMENTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENVIRONMENTS_DESCRIPTOR.index -> builder.environments =
                    deserializer.deserializeList(ENVIRONMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Environment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEnvironmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
