// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The AccountLimit data type.
 *
 * CloudFormation has the following limits per account:
 * + Number of concurrent resources
 * + Number of stacks
 * + Number of stack outputs
 *
 * For more information about these account limits, and other CloudFormation limits, see [CloudFormation quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
 */
public class AccountLimit private constructor(builder: Builder) {
    /**
     * The name of the account limit.
     *
     * Values: `ConcurrentResourcesLimit` | `StackLimit` | `StackOutputsLimit`
     */
    public val name: kotlin.String? = builder.name
    /**
     * The value that's associated with the account limit name.
     */
    public val value: kotlin.Int? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.AccountLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountLimit(")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountLimit

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.AccountLimit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the account limit.
         *
         * Values: `ConcurrentResourcesLimit` | `StackLimit` | `StackOutputsLimit`
         */
        public var name: kotlin.String? = null
        /**
         * The value that's associated with the account limit name.
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.AccountLimit) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.AccountLimit = AccountLimit(this)
    }
}
