// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.
 *
 * For more information about modules, see [Using modules to encapsulate and reuse resource configurations](AWSCloudFormation/latest/UserGuide/modules.html) in the *CloudFormation User Guide*.
 */
public class ModuleInfo private constructor(builder: Builder) {
    /**
     * A concatenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by `/`.
     *
     * In the following example, the resource was created from a module, `moduleA`, that's nested inside a parent module, `moduleB`.
     *
     * `moduleA/moduleB`
     *
     * For more information, see [Referencing resources in a module](AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources) in the *CloudFormation User Guide*.
     */
    public val logicalIdHierarchy: kotlin.String? = builder.logicalIdHierarchy
    /**
     * A concatenated list of the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by `/`.
     *
     * In the following example, the resource was created from a module of type `AWS::First::Example::MODULE`, that's nested inside a parent module of type `AWS::Second::Example::MODULE`.
     *
     * `AWS::First::Example::MODULE/AWS::Second::Example::MODULE`
     */
    public val typeHierarchy: kotlin.String? = builder.typeHierarchy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ModuleInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModuleInfo(")
        append("logicalIdHierarchy=$logicalIdHierarchy,")
        append("typeHierarchy=$typeHierarchy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalIdHierarchy?.hashCode() ?: 0
        result = 31 * result + (typeHierarchy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModuleInfo

        if (logicalIdHierarchy != other.logicalIdHierarchy) return false
        if (typeHierarchy != other.typeHierarchy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ModuleInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A concatenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by `/`.
         *
         * In the following example, the resource was created from a module, `moduleA`, that's nested inside a parent module, `moduleB`.
         *
         * `moduleA/moduleB`
         *
         * For more information, see [Referencing resources in a module](AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources) in the *CloudFormation User Guide*.
         */
        public var logicalIdHierarchy: kotlin.String? = null
        /**
         * A concatenated list of the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by `/`.
         *
         * In the following example, the resource was created from a module of type `AWS::First::Example::MODULE`, that's nested inside a parent module of type `AWS::Second::Example::MODULE`.
         *
         * `AWS::First::Example::MODULE/AWS::Second::Example::MODULE`
         */
        public var typeHierarchy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo) : this() {
            this.logicalIdHierarchy = x.logicalIdHierarchy
            this.typeHierarchy = x.typeHierarchy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ModuleInfo = ModuleInfo(this)
    }
}
