// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An CloudFormation stack, in a specific account and Region, that's part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given Region. A stack instance can exist without a stack—for example, if the stack couldn't be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, in addition to the ID of the actual stack and the stack status.
 */
public class StackInstance private constructor(builder: Builder) {
    /**
     * &#91;Self-managed permissions&#93; The name of the Amazon Web Services account that the stack instance is associated with.
     */
    public val account: kotlin.String? = builder.account
    /**
     * Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs.
     * + `DRIFTED`: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
     * + `NOT_CHECKED`: CloudFormation hasn't checked if the stack instance differs from its expected stack set configuration.
     * + `IN_SYNC`: The stack instance's actual configuration matches its expected stack set configuration.
     * + `UNKNOWN`: This value is reserved for future use.
     */
    public val driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = builder.driftStatus
    /**
     * Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be `NULL` for any stack instance on which drift detection hasn't yet been performed.
     */
    public val lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDriftCheckTimestamp
    /**
     * The last unique ID of a StackSet operation performed on a stack instance.
     */
    public val lastOperationId: kotlin.String? = builder.lastOperationId
    /**
     * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
     */
    public val organizationalUnitId: kotlin.String? = builder.organizationalUnitId
    /**
     * A list of parameters from the stack set template whose values have been overridden in this stack instance.
     */
    public val parameterOverrides: List<Parameter>? = builder.parameterOverrides
    /**
     * The name of the Amazon Web Services Region that the stack instance is associated with.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The ID of the stack instance.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The detailed status of the stack instance.
     */
    public val stackInstanceStatus: aws.sdk.kotlin.services.cloudformation.model.StackInstanceComprehensiveStatus? = builder.stackInstanceStatus
    /**
     * The name or unique ID of the stack set that the stack instance is associated with.
     */
    public val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * + `INOPERABLE`: A `DeleteStackInstances` operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further `UpdateStackSet` operations. You might need to perform a `DeleteStackInstances` operation, with `RetainStacks` set to `true`, to delete the stack instance, and then delete the stack manually.
     * + `OUTDATED`: The stack isn't currently up to date with the stack set because:
     *    + The associated stack failed during a `CreateStackSet` or `UpdateStackSet` operation.
     *    + The stack was part of a `CreateStackSet` or `UpdateStackSet` operation that failed or was stopped before the stack was created or updated.
     * + `CURRENT`: The stack is currently up to date with the stack set.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackInstanceStatus? = builder.status
    /**
     * The explanation for the specific status code that's assigned to this stack instance.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackInstance(")
        append("account=$account,")
        append("driftStatus=$driftStatus,")
        append("lastDriftCheckTimestamp=$lastDriftCheckTimestamp,")
        append("lastOperationId=$lastOperationId,")
        append("organizationalUnitId=$organizationalUnitId,")
        append("parameterOverrides=$parameterOverrides,")
        append("region=$region,")
        append("stackId=$stackId,")
        append("stackInstanceStatus=$stackInstanceStatus,")
        append("stackSetId=$stackSetId,")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (lastDriftCheckTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastOperationId?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitId?.hashCode() ?: 0)
        result = 31 * result + (parameterOverrides?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackInstance

        if (account != other.account) return false
        if (driftStatus != other.driftStatus) return false
        if (lastDriftCheckTimestamp != other.lastDriftCheckTimestamp) return false
        if (lastOperationId != other.lastOperationId) return false
        if (organizationalUnitId != other.organizationalUnitId) return false
        if (parameterOverrides != other.parameterOverrides) return false
        if (region != other.region) return false
        if (stackId != other.stackId) return false
        if (stackInstanceStatus != other.stackInstanceStatus) return false
        if (stackSetId != other.stackSetId) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackInstance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Self-managed permissions&#93; The name of the Amazon Web Services account that the stack instance is associated with.
         */
        public var account: kotlin.String? = null
        /**
         * Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs.
         * + `DRIFTED`: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
         * + `NOT_CHECKED`: CloudFormation hasn't checked if the stack instance differs from its expected stack set configuration.
         * + `IN_SYNC`: The stack instance's actual configuration matches its expected stack set configuration.
         * + `UNKNOWN`: This value is reserved for future use.
         */
        public var driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = null
        /**
         * Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be `NULL` for any stack instance on which drift detection hasn't yet been performed.
         */
        public var lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last unique ID of a StackSet operation performed on a stack instance.
         */
        public var lastOperationId: kotlin.String? = null
        /**
         * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs that you specified for [DeploymentTargets](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html).
         */
        public var organizationalUnitId: kotlin.String? = null
        /**
         * A list of parameters from the stack set template whose values have been overridden in this stack instance.
         */
        public var parameterOverrides: List<Parameter>? = null
        /**
         * The name of the Amazon Web Services Region that the stack instance is associated with.
         */
        public var region: kotlin.String? = null
        /**
         * The ID of the stack instance.
         */
        public var stackId: kotlin.String? = null
        /**
         * The detailed status of the stack instance.
         */
        public var stackInstanceStatus: aws.sdk.kotlin.services.cloudformation.model.StackInstanceComprehensiveStatus? = null
        /**
         * The name or unique ID of the stack set that the stack instance is associated with.
         */
        public var stackSetId: kotlin.String? = null
        /**
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * + `INOPERABLE`: A `DeleteStackInstances` operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further `UpdateStackSet` operations. You might need to perform a `DeleteStackInstances` operation, with `RetainStacks` set to `true`, to delete the stack instance, and then delete the stack manually.
         * + `OUTDATED`: The stack isn't currently up to date with the stack set because:
         *    + The associated stack failed during a `CreateStackSet` or `UpdateStackSet` operation.
         *    + The stack was part of a `CreateStackSet` or `UpdateStackSet` operation that failed or was stopped before the stack was created or updated.
         * + `CURRENT`: The stack is currently up to date with the stack set.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackInstanceStatus? = null
        /**
         * The explanation for the specific status code that's assigned to this stack instance.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackInstance) : this() {
            this.account = x.account
            this.driftStatus = x.driftStatus
            this.lastDriftCheckTimestamp = x.lastDriftCheckTimestamp
            this.lastOperationId = x.lastOperationId
            this.organizationalUnitId = x.organizationalUnitId
            this.parameterOverrides = x.parameterOverrides
            this.region = x.region
            this.stackId = x.stackId
            this.stackInstanceStatus = x.stackInstanceStatus
            this.stackSetId = x.stackSetId
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackInstance = StackInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackInstanceComprehensiveStatus] inside the given [block]
         */
        public fun stackInstanceStatus(block: aws.sdk.kotlin.services.cloudformation.model.StackInstanceComprehensiveStatus.Builder.() -> kotlin.Unit) {
            this.stackInstanceStatus = aws.sdk.kotlin.services.cloudformation.model.StackInstanceComprehensiveStatus.invoke(block)
        }
    }
}
