// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The StackSummary Data Type
 */
public class StackSummary private constructor(builder: Builder) {
    /**
     * The time the stack was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time the stack was deleted.
     */
    public val deletionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionTime
    /**
     * Summarizes information about whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     */
    public val driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformationSummary? = builder.driftInformation
    /**
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
     *
     * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val parentId: kotlin.String? = builder.parentId
    /**
     * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.
     *
     * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val rootId: kotlin.String? = builder.rootId
    /**
     * Unique stack identifier.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The name associated with the stack.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * The current status of the stack.
     */
    public val stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = builder.stackStatus
    /**
     * Success/Failure message associated with the stack status.
     */
    public val stackStatusReason: kotlin.String? = builder.stackStatusReason
    /**
     * The template description of the template used to create the stack.
     */
    public val templateDescription: kotlin.String? = builder.templateDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSummary(")
        append("creationTime=$creationTime,")
        append("deletionTime=$deletionTime,")
        append("driftInformation=$driftInformation,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("parentId=$parentId,")
        append("rootId=$rootId,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("stackStatus=$stackStatus,")
        append("stackStatusReason=$stackStatusReason,")
        append("templateDescription=$templateDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deletionTime?.hashCode() ?: 0)
        result = 31 * result + (driftInformation?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (rootId?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackStatus?.hashCode() ?: 0)
        result = 31 * result + (stackStatusReason?.hashCode() ?: 0)
        result = 31 * result + (templateDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSummary

        if (creationTime != other.creationTime) return false
        if (deletionTime != other.deletionTime) return false
        if (driftInformation != other.driftInformation) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (parentId != other.parentId) return false
        if (rootId != other.rootId) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (stackStatus != other.stackStatus) return false
        if (stackStatusReason != other.stackStatusReason) return false
        if (templateDescription != other.templateDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the stack was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the stack was deleted.
         */
        public var deletionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Summarizes information about whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
         */
        public var driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformationSummary? = null
        /**
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
         *
         * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var parentId: kotlin.String? = null
        /**
         * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.
         *
         * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var rootId: kotlin.String? = null
        /**
         * Unique stack identifier.
         */
        public var stackId: kotlin.String? = null
        /**
         * The name associated with the stack.
         */
        public var stackName: kotlin.String? = null
        /**
         * The current status of the stack.
         */
        public var stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = null
        /**
         * Success/Failure message associated with the stack status.
         */
        public var stackStatusReason: kotlin.String? = null
        /**
         * The template description of the template used to create the stack.
         */
        public var templateDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSummary) : this() {
            this.creationTime = x.creationTime
            this.deletionTime = x.deletionTime
            this.driftInformation = x.driftInformation
            this.lastUpdatedTime = x.lastUpdatedTime
            this.parentId = x.parentId
            this.rootId = x.rootId
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.stackStatus = x.stackStatus
            this.stackStatusReason = x.stackStatusReason
            this.templateDescription = x.templateDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSummary = StackSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackDriftInformationSummary] inside the given [block]
         */
        public fun driftInformation(block: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformationSummary.Builder.() -> kotlin.Unit) {
            this.driftInformation = aws.sdk.kotlin.services.cloudformation.model.StackDriftInformationSummary.invoke(block)
        }
    }
}
