// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse
import aws.sdk.kotlin.services.cloudformation.model.ParameterDeclaration
import aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class GetTemplateSummaryOperationDeserializer: HttpDeserialize<GetTemplateSummaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTemplateSummaryResponse {
        if (!response.status.isSuccess()) {
            throwGetTemplateSummaryError(context, response)
        }
        val builder = GetTemplateSummaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTemplateSummaryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTemplateSummaryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "StackSetNotFoundException" -> StackSetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTemplateSummaryOperationBody(builder: GetTemplateSummaryResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetTemplateSummaryResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetTemplateSummaryResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetTemplateSummary response")
    }
    // end unwrap response wrapper

    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Capabilities"))
    val CAPABILITIESREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CapabilitiesReason"))
    val DECLAREDTRANSFORMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("DeclaredTransforms"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Metadata"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Parameters"))
    val RESOURCEIDENTIFIERSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ResourceIdentifierSummaries"))
    val RESOURCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ResourceTypes"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("GetTemplateSummaryResult"))
        field(CAPABILITIES_DESCRIPTOR)
        field(CAPABILITIESREASON_DESCRIPTOR)
        field(DECLAREDTRANSFORMS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(RESOURCEIDENTIFIERSUMMARIES_DESCRIPTOR)
        field(RESOURCETYPES_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITIES_DESCRIPTOR.index -> builder.capabilities =
                    deserializer.deserializeList(CAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Capability>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Capability.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CAPABILITIESREASON_DESCRIPTOR.index -> builder.capabilitiesReason = deserializeString()
                DECLAREDTRANSFORMS_DESCRIPTOR.index -> builder.declaredTransforms =
                    deserializer.deserializeList(DECLAREDTRANSFORMS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeString()
                PARAMETERS_DESCRIPTOR.index -> builder.parameters =
                    deserializer.deserializeList(PARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterDeclaration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterDeclarationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCEIDENTIFIERSUMMARIES_DESCRIPTOR.index -> builder.resourceIdentifierSummaries =
                    deserializer.deserializeList(RESOURCEIDENTIFIERSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceIdentifierSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceIdentifierSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCETYPES_DESCRIPTOR.index -> builder.resourceTypes =
                    deserializer.deserializeList(RESOURCETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
