// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.CallAs
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceFilter
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListStackInstancesOperationSerializer: HttpSerialize<ListStackInstancesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListStackInstancesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeListStackInstancesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeListStackInstancesOperationBody(context: ExecutionContext, input: ListStackInstancesRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CALLAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("CallAs"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NextToken"))
    val STACKINSTANCEACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackInstanceAccount"))
    val STACKINSTANCEREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackInstanceRegion"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackSetName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ListStackInstancesInput"))
        trait(QueryLiteral("Action", "ListStackInstances"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(CALLAS_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STACKINSTANCEACCOUNT_DESCRIPTOR)
        field(STACKINSTANCEREGION_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.callAs?.let { field(CALLAS_DESCRIPTOR, it.value) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeStackInstanceFilterDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.stackInstanceAccount?.let { field(STACKINSTANCEACCOUNT_DESCRIPTOR, it) }
        input.stackInstanceRegion?.let { field(STACKINSTANCEREGION_DESCRIPTOR, it) }
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
