// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.StackSetOperation
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus
import aws.smithy.kotlin.runtime.serde.Deserializer
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant

internal fun deserializeStackSetOperationDocument(deserializer: Deserializer): StackSetOperation {
    val builder = StackSetOperation.Builder()
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Action"))
    val ADMINISTRATIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AdministrationRoleARN"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationTimestamp"))
    val DEPLOYMENTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DeploymentTargets"))
    val ENDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("EndTimestamp"))
    val EXECUTIONROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ExecutionRoleName"))
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("OperationId"))
    val OPERATIONPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("OperationPreferences"))
    val RETAINSTACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("RetainStacks"))
    val STACKSETDRIFTDETECTIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("StackSetDriftDetectionDetails"))
    val STACKSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackSetId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("StatusDetails"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StatusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("StackSetOperation"))
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        field(ACTION_DESCRIPTOR)
        field(ADMINISTRATIONROLEARN_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DEPLOYMENTTARGETS_DESCRIPTOR)
        field(ENDTIMESTAMP_DESCRIPTOR)
        field(EXECUTIONROLENAME_DESCRIPTOR)
        field(OPERATIONID_DESCRIPTOR)
        field(OPERATIONPREFERENCES_DESCRIPTOR)
        field(RETAINSTACKS_DESCRIPTOR)
        field(STACKSETDRIFTDETECTIONDETAILS_DESCRIPTOR)
        field(STACKSETID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTION_DESCRIPTOR.index -> builder.action = deserializeString().let { StackSetOperationAction.fromValue(it) }
                ADMINISTRATIONROLEARN_DESCRIPTOR.index -> builder.administrationRoleArn = deserializeString()
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromIso8601(it) }
                DEPLOYMENTTARGETS_DESCRIPTOR.index -> builder.deploymentTargets = deserializeDeploymentTargetsDocument(deserializer)
                ENDTIMESTAMP_DESCRIPTOR.index -> builder.endTimestamp = deserializeString().let { Instant.fromIso8601(it) }
                EXECUTIONROLENAME_DESCRIPTOR.index -> builder.executionRoleName = deserializeString()
                OPERATIONID_DESCRIPTOR.index -> builder.operationId = deserializeString()
                OPERATIONPREFERENCES_DESCRIPTOR.index -> builder.operationPreferences = deserializeStackSetOperationPreferencesDocument(deserializer)
                RETAINSTACKS_DESCRIPTOR.index -> builder.retainStacks = deserializeBoolean()
                STACKSETDRIFTDETECTIONDETAILS_DESCRIPTOR.index -> builder.stackSetDriftDetectionDetails = deserializeStackSetDriftDetectionDetailsDocument(deserializer)
                STACKSETID_DESCRIPTOR.index -> builder.stackSetId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StackSetOperationStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeStackSetOperationStatusDetailsDocument(deserializer)
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
    return builder.build()
}
