// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.cloudformation.model.*
import aws.sdk.kotlin.services.cloudformation.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "CloudFormation"
public const val ServiceApiVersion: String = "2010-05-15"
public const val SdkVersion: String = "0.17.7-beta"

internal class DefaultCloudFormationClient(override val config: CloudFormationClient.Config) : CloudFormationClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Activates a public third-party extension, making it available for use in stack templates. For more information, see [Using public extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html) in the *CloudFormation User Guide*.
     *
     * Once you have activated a public third-party extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    override suspend fun activateType(input: ActivateTypeRequest): ActivateTypeResponse {
        val op = SdkHttpOperation.build<ActivateTypeRequest, ActivateTypeResponse> {
            serializer = ActivateTypeOperationSerializer()
            deserializer = ActivateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ActivateType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the account and region.
     *
     * For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    override suspend fun batchDescribeTypeConfigurations(input: BatchDescribeTypeConfigurationsRequest): BatchDescribeTypeConfigurationsResponse {
        val op = SdkHttpOperation.build<BatchDescribeTypeConfigurationsRequest, BatchDescribeTypeConfigurationsResponse> {
            serializer = BatchDescribeTypeConfigurationsOperationSerializer()
            deserializer = BatchDescribeTypeConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDescribeTypeConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
     *
     * You can cancel only stacks that are in the `UPDATE_IN_PROGRESS` state.
     */
    override suspend fun cancelUpdateStack(input: CancelUpdateStackRequest): CancelUpdateStackResponse {
        val op = SdkHttpOperation.build<CancelUpdateStackRequest, CancelUpdateStackResponse> {
            serializer = CancelUpdateStackOperationSerializer()
            deserializer = CancelUpdateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelUpdateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * For a specified stack that's in the `UPDATE_ROLLBACK_FAILED` state, continues rolling it back to the `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually [ fix the error](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed) and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state), and then try to update the stack again.
     *
     * A stack goes into the `UPDATE_ROLLBACK_FAILED` state when CloudFormation can't roll back all changes after a failed stack update. For example, you might have a stack that's rolling back to an old database instance that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to fail.
     */
    override suspend fun continueUpdateRollback(input: ContinueUpdateRollbackRequest): ContinueUpdateRollbackResponse {
        val op = SdkHttpOperation.build<ContinueUpdateRollbackRequest, ContinueUpdateRollbackResponse> {
            serializer = ContinueUpdateRollbackOperationSerializer()
            deserializer = ContinueUpdateRollbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ContinueUpdateRollback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
     *
     * To create a change set for a stack that doesn't exist, for the `ChangeSetType` parameter, specify `CREATE`. To create a change set for an existing stack, specify `UPDATE` for the `ChangeSetType` parameter. To create a change set for an import operation, specify `IMPORT` for the `ChangeSetType` parameter. After the `CreateChangeSet` call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action.
     *
     * When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set.
     *
     * To create a change set for the entire stack hierarchy, set `IncludeNestedStacks` to `True`.
     */
    override suspend fun createChangeSet(input: CreateChangeSetRequest): CreateChangeSetResponse {
        val op = SdkHttpOperation.build<CreateChangeSetRequest, CreateChangeSetResponse> {
            serializer = CreateChangeSetOperationSerializer()
            deserializer = CreateChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateChangeSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the DescribeStacksoperation.
     */
    override suspend fun createStack(input: CreateStackRequest): CreateStackResponse {
        val op = SdkHttpOperation.build<CreateStackRequest, CreateStackResponse> {
            serializer = CreateStackOperationSerializer()
            deserializer = CreateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
     */
    override suspend fun createStackInstances(input: CreateStackInstancesRequest): CreateStackInstancesResponse {
        val op = SdkHttpOperation.build<CreateStackInstancesRequest, CreateStackInstancesResponse> {
            serializer = CreateStackInstancesOperationSerializer()
            deserializer = CreateStackInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStackInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a stack set.
     */
    override suspend fun createStackSet(input: CreateStackSetRequest): CreateStackSetResponse {
        val op = SdkHttpOperation.build<CreateStackSetRequest, CreateStackSetResponse> {
            serializer = CreateStackSetOperationSerializer()
            deserializer = CreateStackSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStackSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deactivates a public extension that was previously activated in this account and region.
     *
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     */
    override suspend fun deactivateType(input: DeactivateTypeRequest): DeactivateTypeResponse {
        val op = SdkHttpOperation.build<DeactivateTypeRequest, DeactivateTypeResponse> {
            serializer = DeactivateTypeOperationSerializer()
            deserializer = DeactivateTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeactivateType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     *
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     *
     * If `IncludeNestedStacks` specifies `True` during the creation of the nested change set, then `DeleteChangeSet` will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of `REVIEW_IN_PROGRESS`.
     */
    override suspend fun deleteChangeSet(input: DeleteChangeSetRequest): DeleteChangeSetResponse {
        val op = SdkHttpOperation.build<DeleteChangeSetRequest, DeleteChangeSetResponse> {
            serializer = DeleteChangeSetOperationSerializer()
            deserializer = DeleteChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteChangeSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the DescribeStacks operation if the deletion has been completed successfully.
     */
    override suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse {
        val op = SdkHttpOperation.build<DeleteStackRequest, DeleteStackResponse> {
            serializer = DeleteStackOperationSerializer()
            deserializer = DeleteStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     */
    override suspend fun deleteStackInstances(input: DeleteStackInstancesRequest): DeleteStackInstancesResponse {
        val op = SdkHttpOperation.build<DeleteStackInstancesRequest, DeleteStackInstancesResponse> {
            serializer = DeleteStackInstancesOperationSerializer()
            deserializer = DeleteStackInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStackInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more information about how to complete this, see DeleteStackInstances.
     */
    override suspend fun deleteStackSet(input: DeleteStackSetRequest): DeleteStackSetResponse {
        val op = SdkHttpOperation.build<DeleteStackSetRequest, DeleteStackSetResponse> {
            serializer = DeleteStackSetOperationSerializer()
            deserializer = DeleteStackSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStackSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     *
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.
     *
     * You can't deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the extension type itself is deregistered as well and marked as deprecated.
     *
     * To view the deprecation status of an extension or extension version, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
     */
    override suspend fun deregisterType(input: DeregisterTypeRequest): DeregisterTypeResponse {
        val op = SdkHttpOperation.build<DeregisterTypeRequest, DeregisterTypeResponse> {
            serializer = DeregisterTypeOperationSerializer()
            deserializer = DeregisterTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [CloudFormation Quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
     */
    override suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse {
        val op = SdkHttpOperation.build<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse> {
            serializer = DescribeAccountLimitsOperationSerializer()
            deserializer = DescribeAccountLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Updating Stacks Using Change Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the CloudFormation User Guide.
     */
    override suspend fun describeChangeSet(input: DescribeChangeSetRequest): DescribeChangeSetResponse {
        val op = SdkHttpOperation.build<DescribeChangeSetRequest, DescribeChangeSetResponse> {
            serializer = DescribeChangeSetOperationSerializer()
            deserializer = DescribeChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChangeSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
     */
    override suspend fun describeChangeSetHooks(input: DescribeChangeSetHooksRequest): DescribeChangeSetHooksResponse {
        val op = SdkHttpOperation.build<DescribeChangeSetHooksRequest, DescribeChangeSetHooksResponse> {
            serializer = DescribeChangeSetHooksOperationSerializer()
            deserializer = DescribeChangeSetHooksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChangeSetHooks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a CloudFormation extension publisher.
     *
     * If you don't supply a `PublisherId`, and you have registered as an extension publisher, `DescribePublisher` returns information about your own publisher account.
     *
     * For more information about registering as a publisher, see:
     * + [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
     * + [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*
     */
    override suspend fun describePublisher(input: DescribePublisherRequest): DescribePublisherResponse {
        val op = SdkHttpOperation.build<DescribePublisherRequest, DescribePublisherResponse> {
            serializer = DescribePublisherOperationSerializer()
            deserializer = DescribePublisherOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePublisher"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use DetectStackDrift to initiate a stack drift detection operation. `DetectStackDrift` returns a `StackDriftDetectionId` you can use to monitor the progress of the operation using `DescribeStackDriftDetectionStatus`. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     */
    override suspend fun describeStackDriftDetectionStatus(input: DescribeStackDriftDetectionStatusRequest): DescribeStackDriftDetectionStatusResponse {
        val op = SdkHttpOperation.build<DescribeStackDriftDetectionStatusRequest, DescribeStackDriftDetectionStatusResponse> {
            serializer = DescribeStackDriftDetectionStatusOperationSerializer()
            deserializer = DescribeStackDriftDetectionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackDriftDetectionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, go to [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html) in the CloudFormation User Guide.
     *
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).
     */
    override suspend fun describeStackEvents(input: DescribeStackEventsRequest): DescribeStackEventsResponse {
        val op = SdkHttpOperation.build<DescribeStackEventsRequest, DescribeStackEventsResponse> {
            serializer = DescribeStackEventsOperationSerializer()
            deserializer = DescribeStackEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.
     *
     * For a list of stack instances that are associated with a specific stack set, use ListStackInstances.
     */
    override suspend fun describeStackInstance(input: DescribeStackInstanceRequest): DescribeStackInstanceResponse {
        val op = SdkHttpOperation.build<DescribeStackInstanceRequest, DescribeStackInstanceResponse> {
            serializer = DescribeStackInstanceOperationSerializer()
            deserializer = DescribeStackInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the specified resource in the specified stack.
     *
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.
     */
    override suspend fun describeStackResource(input: DescribeStackResourceRequest): DescribeStackResourceResponse {
        val op = SdkHttpOperation.build<DescribeStackResourceRequest, DescribeStackResourceResponse> {
            serializer = DescribeStackResourceOperationSerializer()
            deserializer = DescribeStackResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     *
     * For a given stack, there will be one `StackResourceDrift` for each stack resource that has been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't currently support drift detection aren't checked, and so not included. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     *
     * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all supported resources for a given stack.
     */
    override suspend fun describeStackResourceDrifts(input: DescribeStackResourceDriftsRequest): DescribeStackResourceDriftsResponse {
        val op = SdkHttpOperation.build<DescribeStackResourceDriftsRequest, DescribeStackResourceDriftsResponse> {
            serializer = DescribeStackResourceDriftsOperationSerializer()
            deserializer = DescribeStackResourceDriftsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackResourceDrifts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
     *
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use `ListStackResources` instead.
     *
     * For deleted stacks, `DescribeStackResources` returns resource information for up to 90 days after the stack has been deleted.
     *
     * You must specify either `StackName` or `PhysicalResourceId`, but not both. In addition, you can specify `LogicalResourceId` to filter the returned result. For more information about resources, the `LogicalResourceId` and `PhysicalResourceId`, go to the [CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
     *
     * A `ValidationError` is returned if you specify both `StackName` and `PhysicalResourceId` in the same request.
     */
    override suspend fun describeStackResources(input: DescribeStackResourcesRequest): DescribeStackResourcesResponse {
        val op = SdkHttpOperation.build<DescribeStackResourcesRequest, DescribeStackResourcesResponse> {
            serializer = DescribeStackResourcesOperationSerializer()
            deserializer = DescribeStackResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of the specified stack set.
     */
    override suspend fun describeStackSet(input: DescribeStackSetRequest): DescribeStackSetResponse {
        val op = SdkHttpOperation.build<DescribeStackSetRequest, DescribeStackSetResponse> {
            serializer = DescribeStackSetOperationSerializer()
            deserializer = DescribeStackSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of the specified stack set operation.
     */
    override suspend fun describeStackSetOperation(input: DescribeStackSetOperationRequest): DescribeStackSetOperationResponse {
        val op = SdkHttpOperation.build<DescribeStackSetOperationRequest, DescribeStackSetOperationResponse> {
            serializer = DescribeStackSetOperationOperationSerializer()
            deserializer = DescribeStackSetOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackSetOperation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.
     *
     * If the stack doesn't exist, an `ValidationError` is returned.
     */
    override suspend fun describeStacks(input: DescribeStacksRequest): DescribeStacksResponse {
        val op = SdkHttpOperation.build<DescribeStacksRequest, DescribeStacksResponse> {
            serializer = DescribeStacksOperationSerializer()
            deserializer = DescribeStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about an extension that has been registered.
     *
     * If you specify a `VersionId`, `DescribeType` returns information about that specific extension version. Otherwise, it returns information about the default extension version.
     */
    override suspend fun describeType(input: DescribeTypeRequest): DescribeTypeResponse {
        val op = SdkHttpOperation.build<DescribeTypeRequest, DescribeTypeResponse> {
            serializer = DescribeTypeOperationSerializer()
            deserializer = DescribeTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about an extension's registration, including its current status and type and version identifiers.
     *
     * When you initiate a registration request using ` <a>RegisterType</a> `, you can then use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of that registration request.
     *
     * Once the registration request has completed, use ` <a>DescribeType</a> ` to return detailed information about an extension.
     */
    override suspend fun describeTypeRegistration(input: DescribeTypeRegistrationRequest): DescribeTypeRegistrationResponse {
        val op = SdkHttpOperation.build<DescribeTypeRegistrationRequest, DescribeTypeRegistrationResponse> {
            serializer = DescribeTypeRegistrationOperationSerializer()
            deserializer = DescribeTypeRegistrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTypeRegistration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackDrift` to detect drift on all supported resources for a given stack, or DetectStackResourceDrift to detect drift on individual resources.
     *
     * For a list of stack resources that currently support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     *
     * `DetectStackDrift` can take up to several minutes, depending on the number of resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     *
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that stack. Perform `DetectStackDrift` directly on the nested stack itself.
     */
    override suspend fun detectStackDrift(input: DetectStackDriftRequest): DetectStackDriftResponse {
        val op = SdkHttpOperation.build<DetectStackDriftRequest, DetectStackDriftResponse> {
            serializer = DetectStackDriftOperationSerializer()
            deserializer = DetectStackDriftOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectStackDrift"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about whether a resource's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackResourceDrift` to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
     *
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     */
    override suspend fun detectStackResourceDrift(input: DetectStackResourceDriftRequest): DetectStackResourceDriftResponse {
        val op = SdkHttpOperation.build<DetectStackResourceDriftRequest, DetectStackResourceDriftResponse> {
            serializer = DetectStackResourceDriftOperationSerializer()
            deserializer = DetectStackResourceDriftOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectStackResourceDrift"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see [How CloudFormation performs drift detection on a stack set](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
     *
     * `DetectStackSetDrift` returns the `OperationId` of the stack set drift detection operation. Use this operation id with ` <a>DescribeStackSetOperation</a> ` to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the stack set, in addition to the number of resources included in each stack.
     *
     * Once the operation has completed, use the following actions to return drift information:
     * + Use ` <a>DescribeStackSet</a> ` to return detailed information about the stack set, including detailed information about the last *completed* drift operation performed on the stack set. (Information about drift operations that are in progress isn't included.)
     * + Use ` <a>ListStackInstances</a> ` to return a list of stack instances belonging to the stack set, including the drift status and last drift time checked of each instance.
     * + Use ` <a>DescribeStackInstance</a> ` to return detailed information about a specific stack instance, including its drift status and last drift time checked.
     *
     * For more information about performing a drift detection operation on a stack set, see [Detecting unmanaged changes in stack sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
     *
     * You can only run a single drift detection operation on a given stack set at one time.
     *
     * To stop a drift detection stack set operation, use ` <a>StopStackSetOperation</a> `.
     */
    override suspend fun detectStackSetDrift(input: DetectStackSetDriftRequest): DetectStackSetDriftResponse {
        val op = SdkHttpOperation.build<DetectStackSetDriftRequest, DetectStackSetDriftResponse> {
            serializer = DetectStackSetDriftOperationSerializer()
            deserializer = DetectStackSetDriftOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectStackSetDrift"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
     */
    override suspend fun estimateTemplateCost(input: EstimateTemplateCostRequest): EstimateTemplateCostResponse {
        val op = SdkHttpOperation.build<EstimateTemplateCostRequest, EstimateTemplateCostResponse> {
            serializer = EstimateTemplateCostOperationSerializer()
            deserializer = EstimateTemplateCostOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EstimateTemplateCost"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update.
     *
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack.
     *
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy.
     *
     * To create a change set for the entire stack hierarchy, `IncludeNestedStacks` must have been set to `True`.
     */
    override suspend fun executeChangeSet(input: ExecuteChangeSetRequest): ExecuteChangeSetResponse {
        val op = SdkHttpOperation.build<ExecuteChangeSetRequest, ExecuteChangeSetResponse> {
            serializer = ExecuteChangeSetOperationSerializer()
            deserializer = ExecuteChangeSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteChangeSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     */
    override suspend fun getStackPolicy(input: GetStackPolicyRequest): GetStackPolicyResponse {
        val op = SdkHttpOperation.build<GetStackPolicyRequest, GetStackPolicyResponse> {
            serializer = GetStackPolicyOperationSerializer()
            deserializer = GetStackPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStackPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     *
     * For deleted stacks, `GetTemplate` returns the template for up to 90 days after the stack has been deleted.
     *
     * If the template doesn't exist, a `ValidationError` is returned.
     */
    override suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse {
        val op = SdkHttpOperation.build<GetTemplateRequest, GetTemplateResponse> {
            serializer = GetTemplateOperationSerializer()
            deserializer = GetTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a new or existing template. The `GetTemplateSummary` action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or stack set.
     *
     * You can use the `GetTemplateSummary` action when you submit a template, or you can get template information for a stack set, or a running or deleted stack.
     *
     * For deleted stacks, `GetTemplateSummary` returns the template information for up to 90 days after the stack has been deleted. If the template doesn't exist, a `ValidationError` is returned.
     */
    override suspend fun getTemplateSummary(input: GetTemplateSummaryRequest): GetTemplateSummaryResponse {
        val op = SdkHttpOperation.build<GetTemplateSummaryRequest, GetTemplateSummaryResponse> {
            serializer = GetTemplateSummaryOperationSerializer()
            deserializer = GetTemplateSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplateSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
     *
     * `ImportStacksToStackSet` is only supported by self-managed permissions.
     */
    override suspend fun importStacksToStackSet(input: ImportStacksToStackSetRequest): ImportStacksToStackSetResponse {
        val op = SdkHttpOperation.build<ImportStacksToStackSetRequest, ImportStacksToStackSetResponse> {
            serializer = ImportStacksToStackSetOperationSerializer()
            deserializer = ImportStacksToStackSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportStacksToStackSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
     */
    override suspend fun listChangeSets(input: ListChangeSetsRequest): ListChangeSetsResponse {
        val op = SdkHttpOperation.build<ListChangeSetsRequest, ListChangeSetsResponse> {
            serializer = ListChangeSetsOperationSerializer()
            deserializer = ListChangeSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChangeSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
     *
     * For more information, see [ CloudFormation export stack output values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
     */
    override suspend fun listExports(input: ListExportsRequest): ListExportsResponse {
        val op = SdkHttpOperation.build<ListExportsRequest, ListExportsResponse> {
            serializer = ListExportsOperationSerializer()
            deserializer = ListExportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.
     *
     * For more information about importing an exported output value, see the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
     */
    override suspend fun listImports(input: ListImportsRequest): ListImportsResponse {
        val op = SdkHttpOperation.build<ListImportsRequest, ListImportsResponse> {
            serializer = ListImportsOperationSerializer()
            deserializer = ListImportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
     */
    override suspend fun listStackInstances(input: ListStackInstancesRequest): ListStackInstancesResponse {
        val op = SdkHttpOperation.build<ListStackInstancesRequest, ListStackInstancesResponse> {
            serializer = ListStackInstancesOperationSerializer()
            deserializer = ListStackInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns descriptions of all resources of the specified stack.
     *
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.
     */
    override suspend fun listStackResources(input: ListStackResourcesRequest): ListStackResourcesResponse {
        val op = SdkHttpOperation.build<ListStackResourcesRequest, ListStackResourcesResponse> {
            serializer = ListStackResourcesOperationSerializer()
            deserializer = ListStackResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about the results of a stack set operation.
     */
    override suspend fun listStackSetOperationResults(input: ListStackSetOperationResultsRequest): ListStackSetOperationResultsResponse {
        val op = SdkHttpOperation.build<ListStackSetOperationResultsRequest, ListStackSetOperationResultsResponse> {
            serializer = ListStackSetOperationResultsOperationSerializer()
            deserializer = ListStackSetOperationResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackSetOperationResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about operations performed on a stack set.
     */
    override suspend fun listStackSetOperations(input: ListStackSetOperationsRequest): ListStackSetOperationsResponse {
        val op = SdkHttpOperation.build<ListStackSetOperationsRequest, ListStackSetOperationsResponse> {
            serializer = ListStackSetOperationsOperationSerializer()
            deserializer = ListStackSetOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackSetOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about stack sets that are associated with the user.
     * + &#91;Self-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to your Amazon Web Services account, `ListStackSets` returns all self-managed stack sets in your Amazon Web Services account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to the organization's management account, `ListStackSets` returns all stack sets in the management account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `DELEGATED_ADMIN` while signed in to your member account, `ListStackSets` returns all stack sets with service-managed permissions in the management account.
     */
    override suspend fun listStackSets(input: ListStackSetsRequest): ListStackSetsResponse {
        val op = SdkHttpOperation.build<ListStackSetsRequest, ListStackSetsResponse> {
            serializer = ListStackSetsOperationSerializer()
            deserializer = ListStackSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStackSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
     */
    override suspend fun listStacks(input: ListStacksRequest): ListStacksResponse {
        val op = SdkHttpOperation.build<ListStacksRequest, ListStacksResponse> {
            serializer = ListStacksOperationSerializer()
            deserializer = ListStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of registration tokens for the specified extension(s).
     */
    override suspend fun listTypeRegistrations(input: ListTypeRegistrationsRequest): ListTypeRegistrationsResponse {
        val op = SdkHttpOperation.build<ListTypeRegistrationsRequest, ListTypeRegistrationsResponse> {
            serializer = ListTypeRegistrationsOperationSerializer()
            deserializer = ListTypeRegistrationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypeRegistrations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about the versions of an extension.
     */
    override suspend fun listTypeVersions(input: ListTypeVersionsRequest): ListTypeVersionsResponse {
        val op = SdkHttpOperation.build<ListTypeVersionsRequest, ListTypeVersionsResponse> {
            serializer = ListTypeVersionsOperationSerializer()
            deserializer = ListTypeVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypeVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about extension that have been registered with CloudFormation.
     */
    override suspend fun listTypes(input: ListTypesRequest): ListTypesResponse {
        val op = SdkHttpOperation.build<ListTypesRequest, ListTypesResponse> {
            serializer = ListTypesOperationSerializer()
            deserializer = ListTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*.
     *
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
     */
    override suspend fun publishType(input: PublishTypeRequest): PublishTypeResponse {
        val op = SdkHttpOperation.build<PublishTypeRequest, PublishTypeResponse> {
            serializer = PublishTypeOperationSerializer()
            deserializer = PublishTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PublishType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reports progress of a resource handler to CloudFormation.
     *
     * Reserved for use by the [CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html). Don't use this API in your code.
     */
    override suspend fun recordHandlerProgress(input: RecordHandlerProgressRequest): RecordHandlerProgressResponse {
        val op = SdkHttpOperation.build<RecordHandlerProgressRequest, RecordHandlerProgressResponse> {
            serializer = RecordHandlerProgressOperationSerializer()
            deserializer = RecordHandlerProgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RecordHandlerProgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
     *
     * For information about requirements for registering as a public extension publisher, see [Registering your account to publish CloudFormation extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs) in the *CloudFormation CLI User Guide*.
     */
    override suspend fun registerPublisher(input: RegisterPublisherRequest): RegisterPublisherResponse {
        val op = SdkHttpOperation.build<RegisterPublisherRequest, RegisterPublisherResponse> {
            serializer = RegisterPublisherOperationSerializer()
            deserializer = RegisterPublisherOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterPublisher"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
     * + Validating the extension schema.
     * + Determining which handlers, if any, have been specified for the extension.
     * + Making the extension available for use in your account.
     *
     * For more information about how to develop extensions and ready them for registration, see [Creating Resource Providers](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) in the *CloudFormation CLI User Guide*.
     *
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per region. Use [DeregisterType](AWSCloudFormation/latest/APIReference/API_DeregisterType.html) to deregister specific extension versions if necessary.
     *
     * Once you have initiated a registration request using ` <a>RegisterType</a> `, you can use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of the registration request.
     *
     * Once you have registered a private extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    override suspend fun registerType(input: RegisterTypeRequest): RegisterTypeResponse {
        val op = SdkHttpOperation.build<RegisterTypeRequest, RegisterTypeResponse> {
            serializer = RegisterTypeOperationSerializer()
            deserializer = RegisterTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When specifying `RollbackStack`, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the DescribeStacks operation.
     *
     * Rolls back the specified stack to the last known stable state from `CREATE_FAILED` or `UPDATE_FAILED` stack statuses.
     *
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a `*_COMPLETE`. This includes the following stack statuses.
     * + `CREATE_COMPLETE`
     * + `UPDATE_COMPLETE`
     * + `UPDATE_ROLLBACK_COMPLETE`
     * + `IMPORT_COMPLETE`
     * + `IMPORT_ROLLBACK_COMPLETE`
     */
    override suspend fun rollbackStack(input: RollbackStackRequest): RollbackStackResponse {
        val op = SdkHttpOperation.build<RollbackStackRequest, RollbackStackResponse> {
            serializer = RollbackStackOperationSerializer()
            deserializer = RollbackStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RollbackStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets a stack policy for a specified stack.
     */
    override suspend fun setStackPolicy(input: SetStackPolicyRequest): SetStackPolicyResponse {
        val op = SdkHttpOperation.build<SetStackPolicyRequest, SetStackPolicyResponse> {
            serializer = SetStackPolicyOperationSerializer()
            deserializer = SetStackPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetStackPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and region.
     *
     * To view the current configuration data for an extension, refer to the `ConfigurationSchema` element of [DescribeType](AWSCloudFormation/latest/APIReference/API_DescribeType.html). For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     *
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see [Using dynamic references to specify template values](https://docs.aws.amazon.com/) in the *CloudFormation User Guide*.
     */
    override suspend fun setTypeConfiguration(input: SetTypeConfigurationRequest): SetTypeConfigurationResponse {
        val op = SdkHttpOperation.build<SetTypeConfigurationRequest, SetTypeConfigurationResponse> {
            serializer = SetTypeConfigurationOperationSerializer()
            deserializer = SetTypeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetTypeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
     */
    override suspend fun setTypeDefaultVersion(input: SetTypeDefaultVersionRequest): SetTypeDefaultVersionResponse {
        val op = SdkHttpOperation.build<SetTypeDefaultVersionRequest, SetTypeDefaultVersionResponse> {
            serializer = SetTypeDefaultVersionOperationSerializer()
            deserializer = SetTypeDefaultVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetTypeDefaultVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a signal to the specified resource with a success or failure status. You can use the `SignalResource` operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The `SignalResource` operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
     */
    override suspend fun signalResource(input: SignalResourceRequest): SignalResourceResponse {
        val op = SdkHttpOperation.build<SignalResourceRequest, SignalResourceResponse> {
            serializer = SignalResourceOperationSerializer()
            deserializer = SignalResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SignalResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
     */
    override suspend fun stopStackSetOperation(input: StopStackSetOperationRequest): StopStackSetOperationResponse {
        val op = SdkHttpOperation.build<StopStackSetOperationRequest, StopStackSetOperationResponse> {
            serializer = StopStackSetOperationOperationSerializer()
            deserializer = StopStackSetOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopStackSetOperation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
     * + For resource types, this includes passing all contracts tests defined for the type.
     * + For modules, this includes determining if the module's model meets all necessary requirements.
     *
     * For more information, see [Testing your public extension prior to publishing](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing) in the *CloudFormation CLI User Guide*.
     *
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and region for testing.
     *
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see [RegisterType](AWSCloudFormation/latest/APIReference/API_RegisterType.html).
     *
     * Once you've initiated testing on an extension using `TestType`, you can use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html) to monitor the current test status and test status description for the extension.
     *
     * An extension must have a test status of `PASSED` before it can be published. For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html) in the *CloudFormation CLI User Guide*.
     */
    override suspend fun testType(input: TestTypeRequest): TestTypeResponse {
        val op = SdkHttpOperation.build<TestTypeRequest, TestTypeResponse> {
            serializer = TestTypeOperationSerializer()
            deserializer = TestTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the DescribeStacks action.
     *
     * To get a copy of the template for an existing stack, you can use the GetTemplate action.
     *
     * For more information about creating an update template, updating a stack, and monitoring the progress of the update, see [Updating a Stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
     */
    override suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse {
        val op = SdkHttpOperation.build<UpdateStackRequest, UpdateStackResponse> {
            serializer = UpdateStackOperationSerializer()
            deserializer = UpdateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
     *
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to create additional stack instances, use [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
     *
     * During stack set updates, any parameters overridden for a stack instance aren't updated, but retain their overridden value.
     *
     * You can only update the parameter *values* that are specified in the stack set; to add or delete a parameter itself, use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
     */
    override suspend fun updateStackInstances(input: UpdateStackInstancesRequest): UpdateStackInstancesResponse {
        val op = SdkHttpOperation.build<UpdateStackInstancesRequest, UpdateStackInstancesResponse> {
            serializer = UpdateStackInstancesOperationSerializer()
            deserializer = UpdateStackInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStackInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.
     *
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above a specified failure tolerance), the stack set is updated with your changes. Subsequent CreateStackInstances calls on the specified stack set use the updated stack set.
     */
    override suspend fun updateStackSet(input: UpdateStackSetRequest): UpdateStackSetResponse {
        val op = SdkHttpOperation.build<UpdateStackSetRequest, UpdateStackSetResponse> {
            serializer = UpdateStackSetOperationSerializer()
            deserializer = UpdateStackSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStackSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protecting a Stack From Being Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
     *
     * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
     */
    override suspend fun updateTerminationProtection(input: UpdateTerminationProtectionRequest): UpdateTerminationProtectionResponse {
        val op = SdkHttpOperation.build<UpdateTerminationProtectionRequest, UpdateTerminationProtectionResponse> {
            serializer = UpdateTerminationProtectionOperationSerializer()
            deserializer = UpdateTerminationProtectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTerminationProtection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
     */
    override suspend fun validateTemplate(input: ValidateTemplateRequest): ValidateTemplateResponse {
        val op = SdkHttpOperation.build<ValidateTemplateRequest, ValidateTemplateResponse> {
            serializer = ValidateTemplateOperationSerializer()
            deserializer = ValidateTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidateTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cloudformation"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "cloudformation")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
