// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



public class ImportStacksToStackSetRequest private constructor(builder: Builder) {
    /**
     * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + For service managed stack sets, specify `DELEGATED_ADMIN`.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * A unique, user defined, identifier for the stack set operation.
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * The user-specified preferences for how CloudFormation performs a stack set operation.
     *
     * For more information about maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
     */
    public val operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = builder.operationPreferences
    /**
     * The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
     */
    public val organizationalUnitIds: List<String>? = builder.organizationalUnitIds
    /**
     * The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
     *
     * Specify either `StackIds` or `StackIdsUrl`.
     */
    public val stackIds: List<String>? = builder.stackIds
    /**
     * The Amazon S3 URL which contains list of stack ids to be inputted.
     *
     * Specify either `StackIds` or `StackIdsUrl`.
     */
    public val stackIdsUrl: kotlin.String? = builder.stackIdsUrl
    /**
     * The name of the stack set. The name must be unique in the Region where you create your stack set.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportStacksToStackSetRequest(")
        append("callAs=$callAs,")
        append("operationId=$operationId,")
        append("operationPreferences=$operationPreferences,")
        append("organizationalUnitIds=$organizationalUnitIds,")
        append("stackIds=$stackIds,")
        append("stackIdsUrl=$stackIdsUrl,")
        append("stackSetName=$stackSetName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAs?.hashCode() ?: 0
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (operationPreferences?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        result = 31 * result + (stackIds?.hashCode() ?: 0)
        result = 31 * result + (stackIdsUrl?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportStacksToStackSetRequest

        if (callAs != other.callAs) return false
        if (operationId != other.operationId) return false
        if (operationPreferences != other.operationPreferences) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false
        if (stackIds != other.stackIds) return false
        if (stackIdsUrl != other.stackIdsUrl) return false
        if (stackSetName != other.stackSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + For service managed stack sets, specify `DELEGATED_ADMIN`.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * A unique, user defined, identifier for the stack set operation.
         */
        public var operationId: kotlin.String? = null
        /**
         * The user-specified preferences for how CloudFormation performs a stack set operation.
         *
         * For more information about maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
         */
        public var operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = null
        /**
         * The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
         */
        public var organizationalUnitIds: List<String>? = null
        /**
         * The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
         *
         * Specify either `StackIds` or `StackIdsUrl`.
         */
        public var stackIds: List<String>? = null
        /**
         * The Amazon S3 URL which contains list of stack ids to be inputted.
         *
         * Specify either `StackIds` or `StackIdsUrl`.
         */
        public var stackIdsUrl: kotlin.String? = null
        /**
         * The name of the stack set. The name must be unique in the Region where you create your stack set.
         */
        public var stackSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest) : this() {
            this.callAs = x.callAs
            this.operationId = x.operationId
            this.operationPreferences = x.operationPreferences
            this.organizationalUnitIds = x.organizationalUnitIds
            this.stackIds = x.stackIds
            this.stackIdsUrl = x.stackIdsUrl
            this.stackSetName = x.stackSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest = ImportStacksToStackSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences] inside the given [block]
         */
        public fun operationPreferences(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.Builder.() -> kotlin.Unit) {
            this.operationPreferences = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.invoke(block)
        }
    }
}
