// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains summary information about a specific version of a CloudFormation extension.
 */
public class TypeVersionSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the extension version.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the extension version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the specified extension version is set as the default version.
     *
     * This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, CloudFormation returns `null`.
     */
    public val isDefaultVersion: kotlin.Boolean? = builder.isDefaultVersion
    /**
     * For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns `null`.
     *
     * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and region when a new version is released. For more information, see [Setting CloudFormation to automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
     */
    public val publicVersionNumber: kotlin.String? = builder.publicVersionNumber
    /**
     * When the version was registered.
     */
    public val timeCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.timeCreated
    /**
     * The kind of extension.
     */
    public val type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = builder.type
    /**
     * The name of the extension.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it's registered.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TypeVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypeVersionSummary(")
        append("arn=$arn,")
        append("description=$description,")
        append("isDefaultVersion=$isDefaultVersion,")
        append("publicVersionNumber=$publicVersionNumber,")
        append("timeCreated=$timeCreated,")
        append("type=$type,")
        append("typeName=$typeName,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isDefaultVersion?.hashCode() ?: 0)
        result = 31 * result + (publicVersionNumber?.hashCode() ?: 0)
        result = 31 * result + (timeCreated?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypeVersionSummary

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (isDefaultVersion != other.isDefaultVersion) return false
        if (publicVersionNumber != other.publicVersionNumber) return false
        if (timeCreated != other.timeCreated) return false
        if (type != other.type) return false
        if (typeName != other.typeName) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TypeVersionSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the extension version.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the extension version.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the specified extension version is set as the default version.
         *
         * This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, CloudFormation returns `null`.
         */
        public var isDefaultVersion: kotlin.Boolean? = null
        /**
         * For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns `null`.
         *
         * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and region when a new version is released. For more information, see [Setting CloudFormation to automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
         */
        public var publicVersionNumber: kotlin.String? = null
        /**
         * When the version was registered.
         */
        public var timeCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The kind of extension.
         */
        public var type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = null
        /**
         * The name of the extension.
         */
        public var typeName: kotlin.String? = null
        /**
         * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it's registered.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TypeVersionSummary) : this() {
            this.arn = x.arn
            this.description = x.description
            this.isDefaultVersion = x.isDefaultVersion
            this.publicVersionNumber = x.publicVersionNumber
            this.timeCreated = x.timeCreated
            this.type = x.type
            this.typeName = x.typeName
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TypeVersionSummary = TypeVersionSummary(this)
    }
}
