// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsError
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails
import aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class BatchDescribeTypeConfigurationsOperationDeserializer: HttpDeserialize<BatchDescribeTypeConfigurationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDescribeTypeConfigurationsResponse {
        if (!response.status.isSuccess()) {
            throwBatchDescribeTypeConfigurationsError(context, response)
        }
        val builder = BatchDescribeTypeConfigurationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDescribeTypeConfigurationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDescribeTypeConfigurationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedResponse)
        "TypeConfigurationNotFoundException" -> TypeConfigurationNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDescribeTypeConfigurationsOperationBody(builder: BatchDescribeTypeConfigurationsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("BatchDescribeTypeConfigurationsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("BatchDescribeTypeConfigurationsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap BatchDescribeTypeConfigurations response")
    }
    // end unwrap response wrapper

    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Errors"))
    val TYPECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("TypeConfigurations"))
    val UNPROCESSEDTYPECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UnprocessedTypeConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("BatchDescribeTypeConfigurationsResult"))
        field(ERRORS_DESCRIPTOR)
        field(TYPECONFIGURATIONS_DESCRIPTOR)
        field(UNPROCESSEDTYPECONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDescribeTypeConfigurationsError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDescribeTypeConfigurationsErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPECONFIGURATIONS_DESCRIPTOR.index -> builder.typeConfigurations =
                    deserializer.deserializeList(TYPECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TypeConfigurationDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTypeConfigurationDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDTYPECONFIGURATIONS_DESCRIPTOR.index -> builder.unprocessedTypeConfigurations =
                    deserializer.deserializeList(UNPROCESSEDTYPECONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TypeConfigurationIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTypeConfigurationIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
