// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.CancelUpdateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class CancelUpdateStackOperationDeserializer: HttpDeserialize<CancelUpdateStackResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CancelUpdateStackResponse {
        if (!response.status.isSuccess()) {
            throwCancelUpdateStackError(context, response)
        }
        val builder = CancelUpdateStackResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwCancelUpdateStackError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TokenAlreadyExistsException" -> TokenAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
