// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudformation.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.cloudformation.endpoints.EndpointProvider
import aws.sdk.kotlin.services.cloudformation.model.*
import aws.sdk.kotlin.services.cloudformation.model.ActivateTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.ActivateTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
import aws.sdk.kotlin.services.cloudformation.model.CancelUpdateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.CancelUpdateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.ContinueUpdateRollbackRequest
import aws.sdk.kotlin.services.cloudformation.model.ContinueUpdateRollbackResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.CreateStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeactivateTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DeactivateTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackResponse
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DeleteStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DeregisterTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DeregisterTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackInstanceRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackInstanceResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetOperationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetOperationResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackResourceDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackResourceDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest
import aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftResponse
import aws.sdk.kotlin.services.cloudformation.model.EstimateTemplateCostRequest
import aws.sdk.kotlin.services.cloudformation.model.EstimateTemplateCostResponse
import aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.ExecuteChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.GetStackPolicyRequest
import aws.sdk.kotlin.services.cloudformation.model.GetStackPolicyResponse
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateResponse
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryRequest
import aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse
import aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListExportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListExportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypesResponse
import aws.sdk.kotlin.services.cloudformation.model.PublishTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.PublishTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.RecordHandlerProgressRequest
import aws.sdk.kotlin.services.cloudformation.model.RecordHandlerProgressResponse
import aws.sdk.kotlin.services.cloudformation.model.RegisterPublisherRequest
import aws.sdk.kotlin.services.cloudformation.model.RegisterPublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.RegisterTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.RegisterTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.RollbackStackRequest
import aws.sdk.kotlin.services.cloudformation.model.RollbackStackResponse
import aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest
import aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyResponse
import aws.sdk.kotlin.services.cloudformation.model.SetTypeConfigurationRequest
import aws.sdk.kotlin.services.cloudformation.model.SetTypeConfigurationResponse
import aws.sdk.kotlin.services.cloudformation.model.SetTypeDefaultVersionRequest
import aws.sdk.kotlin.services.cloudformation.model.SetTypeDefaultVersionResponse
import aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest
import aws.sdk.kotlin.services.cloudformation.model.SignalResourceResponse
import aws.sdk.kotlin.services.cloudformation.model.StopStackSetOperationRequest
import aws.sdk.kotlin.services.cloudformation.model.StopStackSetOperationResponse
import aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest
import aws.sdk.kotlin.services.cloudformation.model.TestTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackSetResponse
import aws.sdk.kotlin.services.cloudformation.model.UpdateTerminationProtectionRequest
import aws.sdk.kotlin.services.cloudformation.model.UpdateTerminationProtectionResponse
import aws.sdk.kotlin.services.cloudformation.model.ValidateTemplateRequest
import aws.sdk.kotlin.services.cloudformation.model.ValidateTemplateResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # CloudFormation
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure deployments predictably and repeatedly. You can use CloudFormation to leverage Amazon Web Services products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly reliable, highly scalable, cost-effective applications without creating or configuring the underlying Amazon Web Services infrastructure.
 *
 * With CloudFormation, you declare all your resources and dependencies in a template file. The template defines a collection of resources as a single unit called a stack. CloudFormation creates and deletes all member resources of the stack together and manages all dependencies between the resources for you.
 *
 * For more information about CloudFormation, see the [CloudFormation product page](http://aws.amazon.com/cloudformation/).
 *
 * CloudFormation makes use of other Amazon Web Services products. If you need additional technical information about a specific Amazon Web Services product, you can find the product's technical documentation at `docs.aws.amazon.com`[](https://docs.aws.amazon.com/).
 */
public interface CloudFormationClient : SdkClient {

    override val serviceName: String
        get() = "CloudFormation"
    /**
     * CloudFormationClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): CloudFormationClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCloudFormationClient(config)
        }

        public operator fun invoke(config: Config): CloudFormationClient = DefaultCloudFormationClient(config)

        /**
         * Construct a [CloudFormationClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CloudFormationClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultCloudFormationClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CloudFormation")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Activates a public third-party extension, making it available for use in stack templates. For more information, see [Using public extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html) in the *CloudFormation User Guide*.
     *
     * Once you have activated a public third-party extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    public suspend fun activateType(input: ActivateTypeRequest = ActivateTypeRequest {}): ActivateTypeResponse

    /**
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the account and region.
     *
     * For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    public suspend fun batchDescribeTypeConfigurations(input: BatchDescribeTypeConfigurationsRequest): BatchDescribeTypeConfigurationsResponse

    /**
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
     *
     * You can cancel only stacks that are in the `UPDATE_IN_PROGRESS` state.
     */
    public suspend fun cancelUpdateStack(input: CancelUpdateStackRequest): CancelUpdateStackResponse

    /**
     * For a specified stack that's in the `UPDATE_ROLLBACK_FAILED` state, continues rolling it back to the `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually [ fix the error](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed) and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state), and then try to update the stack again.
     *
     * A stack goes into the `UPDATE_ROLLBACK_FAILED` state when CloudFormation can't roll back all changes after a failed stack update. For example, you might have a stack that's rolling back to an old database instance that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to fail.
     */
    public suspend fun continueUpdateRollback(input: ContinueUpdateRollbackRequest): ContinueUpdateRollbackResponse

    /**
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
     *
     * To create a change set for a stack that doesn't exist, for the `ChangeSetType` parameter, specify `CREATE`. To create a change set for an existing stack, specify `UPDATE` for the `ChangeSetType` parameter. To create a change set for an import operation, specify `IMPORT` for the `ChangeSetType` parameter. After the `CreateChangeSet` call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action.
     *
     * When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set.
     *
     * To create a change set for the entire stack hierarchy, set `IncludeNestedStacks` to `True`.
     */
    public suspend fun createChangeSet(input: CreateChangeSetRequest): CreateChangeSetResponse

    /**
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the DescribeStacksoperation.
     */
    public suspend fun createStack(input: CreateStackRequest): CreateStackResponse

    /**
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
     */
    public suspend fun createStackInstances(input: CreateStackInstancesRequest): CreateStackInstancesResponse

    /**
     * Creates a stack set.
     */
    public suspend fun createStackSet(input: CreateStackSetRequest): CreateStackSetResponse

    /**
     * Deactivates a public extension that was previously activated in this account and region.
     *
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     */
    public suspend fun deactivateType(input: DeactivateTypeRequest = DeactivateTypeRequest {}): DeactivateTypeResponse

    /**
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     *
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     *
     * If `IncludeNestedStacks` specifies `True` during the creation of the nested change set, then `DeleteChangeSet` will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of `REVIEW_IN_PROGRESS`.
     */
    public suspend fun deleteChangeSet(input: DeleteChangeSetRequest): DeleteChangeSetResponse

    /**
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the DescribeStacks operation if the deletion has been completed successfully.
     */
    public suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse

    /**
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     */
    public suspend fun deleteStackInstances(input: DeleteStackInstancesRequest): DeleteStackInstancesResponse

    /**
     * Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more information about how to complete this, see DeleteStackInstances.
     */
    public suspend fun deleteStackSet(input: DeleteStackSetRequest): DeleteStackSetResponse

    /**
     * Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     *
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.
     *
     * You can't deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the extension type itself is deregistered as well and marked as deprecated.
     *
     * To view the deprecation status of an extension or extension version, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
     */
    public suspend fun deregisterType(input: DeregisterTypeRequest = DeregisterTypeRequest {}): DeregisterTypeResponse

    /**
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [CloudFormation Quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest {}): DescribeAccountLimitsResponse

    /**
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Updating Stacks Using Change Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the CloudFormation User Guide.
     */
    public suspend fun describeChangeSet(input: DescribeChangeSetRequest): DescribeChangeSetResponse

    /**
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
     */
    public suspend fun describeChangeSetHooks(input: DescribeChangeSetHooksRequest): DescribeChangeSetHooksResponse

    /**
     * Returns information about a CloudFormation extension publisher.
     *
     * If you don't supply a `PublisherId`, and you have registered as an extension publisher, `DescribePublisher` returns information about your own publisher account.
     *
     * For more information about registering as a publisher, see:
     * + [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
     * + [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*
     */
    public suspend fun describePublisher(input: DescribePublisherRequest = DescribePublisherRequest {}): DescribePublisherResponse

    /**
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use DetectStackDrift to initiate a stack drift detection operation. `DetectStackDrift` returns a `StackDriftDetectionId` you can use to monitor the progress of the operation using `DescribeStackDriftDetectionStatus`. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     */
    public suspend fun describeStackDriftDetectionStatus(input: DescribeStackDriftDetectionStatusRequest): DescribeStackDriftDetectionStatusResponse

    /**
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, go to [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html) in the CloudFormation User Guide.
     *
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).
     */
    public suspend fun describeStackEvents(input: DescribeStackEventsRequest = DescribeStackEventsRequest {}): DescribeStackEventsResponse

    /**
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.
     *
     * For a list of stack instances that are associated with a specific stack set, use ListStackInstances.
     */
    public suspend fun describeStackInstance(input: DescribeStackInstanceRequest): DescribeStackInstanceResponse

    /**
     * Returns a description of the specified resource in the specified stack.
     *
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.
     */
    public suspend fun describeStackResource(input: DescribeStackResourceRequest): DescribeStackResourceResponse

    /**
     * Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     *
     * For a given stack, there will be one `StackResourceDrift` for each stack resource that has been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't currently support drift detection aren't checked, and so not included. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     *
     * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all supported resources for a given stack.
     */
    public suspend fun describeStackResourceDrifts(input: DescribeStackResourceDriftsRequest): DescribeStackResourceDriftsResponse

    /**
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
     *
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use `ListStackResources` instead.
     *
     * For deleted stacks, `DescribeStackResources` returns resource information for up to 90 days after the stack has been deleted.
     *
     * You must specify either `StackName` or `PhysicalResourceId`, but not both. In addition, you can specify `LogicalResourceId` to filter the returned result. For more information about resources, the `LogicalResourceId` and `PhysicalResourceId`, go to the [CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
     *
     * A `ValidationError` is returned if you specify both `StackName` and `PhysicalResourceId` in the same request.
     */
    public suspend fun describeStackResources(input: DescribeStackResourcesRequest = DescribeStackResourcesRequest {}): DescribeStackResourcesResponse

    /**
     * Returns the description of the specified stack set.
     */
    public suspend fun describeStackSet(input: DescribeStackSetRequest): DescribeStackSetResponse

    /**
     * Returns the description of the specified stack set operation.
     */
    public suspend fun describeStackSetOperation(input: DescribeStackSetOperationRequest): DescribeStackSetOperationResponse

    /**
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.
     *
     * If the stack doesn't exist, an `ValidationError` is returned.
     */
    public suspend fun describeStacks(input: DescribeStacksRequest = DescribeStacksRequest {}): DescribeStacksResponse

    /**
     * Returns detailed information about an extension that has been registered.
     *
     * If you specify a `VersionId`, `DescribeType` returns information about that specific extension version. Otherwise, it returns information about the default extension version.
     */
    public suspend fun describeType(input: DescribeTypeRequest = DescribeTypeRequest {}): DescribeTypeResponse

    /**
     * Returns information about an extension's registration, including its current status and type and version identifiers.
     *
     * When you initiate a registration request using ` <a>RegisterType</a> `, you can then use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of that registration request.
     *
     * Once the registration request has completed, use ` <a>DescribeType</a> ` to return detailed information about an extension.
     */
    public suspend fun describeTypeRegistration(input: DescribeTypeRegistrationRequest): DescribeTypeRegistrationResponse

    /**
     * Detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackDrift` to detect drift on all supported resources for a given stack, or DetectStackResourceDrift to detect drift on individual resources.
     *
     * For a list of stack resources that currently support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     *
     * `DetectStackDrift` can take up to several minutes, depending on the number of resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
     *
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that stack. Perform `DetectStackDrift` directly on the nested stack itself.
     */
    public suspend fun detectStackDrift(input: DetectStackDriftRequest): DetectStackDriftResponse

    /**
     * Returns information about whether a resource's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     *
     * Use `DetectStackResourceDrift` to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
     *
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
     */
    public suspend fun detectStackResourceDrift(input: DetectStackResourceDriftRequest): DetectStackResourceDriftResponse

    /**
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see [How CloudFormation performs drift detection on a stack set](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
     *
     * `DetectStackSetDrift` returns the `OperationId` of the stack set drift detection operation. Use this operation id with ` <a>DescribeStackSetOperation</a> ` to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the stack set, in addition to the number of resources included in each stack.
     *
     * Once the operation has completed, use the following actions to return drift information:
     * + Use ` <a>DescribeStackSet</a> ` to return detailed information about the stack set, including detailed information about the last *completed* drift operation performed on the stack set. (Information about drift operations that are in progress isn't included.)
     * + Use ` <a>ListStackInstances</a> ` to return a list of stack instances belonging to the stack set, including the drift status and last drift time checked of each instance.
     * + Use ` <a>DescribeStackInstance</a> ` to return detailed information about a specific stack instance, including its drift status and last drift time checked.
     *
     * For more information about performing a drift detection operation on a stack set, see [Detecting unmanaged changes in stack sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
     *
     * You can only run a single drift detection operation on a given stack set at one time.
     *
     * To stop a drift detection stack set operation, use ` <a>StopStackSetOperation</a> `.
     */
    public suspend fun detectStackSetDrift(input: DetectStackSetDriftRequest): DetectStackSetDriftResponse

    /**
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
     */
    public suspend fun estimateTemplateCost(input: EstimateTemplateCostRequest = EstimateTemplateCostRequest {}): EstimateTemplateCostResponse

    /**
     * Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update.
     *
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack.
     *
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy.
     *
     * To create a change set for the entire stack hierarchy, `IncludeNestedStacks` must have been set to `True`.
     */
    public suspend fun executeChangeSet(input: ExecuteChangeSetRequest): ExecuteChangeSetResponse

    /**
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     */
    public suspend fun getStackPolicy(input: GetStackPolicyRequest): GetStackPolicyResponse

    /**
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     *
     * For deleted stacks, `GetTemplate` returns the template for up to 90 days after the stack has been deleted.
     *
     * If the template doesn't exist, a `ValidationError` is returned.
     */
    public suspend fun getTemplate(input: GetTemplateRequest = GetTemplateRequest {}): GetTemplateResponse

    /**
     * Returns information about a new or existing template. The `GetTemplateSummary` action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or stack set.
     *
     * You can use the `GetTemplateSummary` action when you submit a template, or you can get template information for a stack set, or a running or deleted stack.
     *
     * For deleted stacks, `GetTemplateSummary` returns the template information for up to 90 days after the stack has been deleted. If the template doesn't exist, a `ValidationError` is returned.
     */
    public suspend fun getTemplateSummary(input: GetTemplateSummaryRequest = GetTemplateSummaryRequest {}): GetTemplateSummaryResponse

    /**
     * Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
     *
     * `ImportStacksToStackSet` is only supported by self-managed permissions.
     */
    public suspend fun importStacksToStackSet(input: ImportStacksToStackSetRequest): ImportStacksToStackSetResponse

    /**
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
     */
    public suspend fun listChangeSets(input: ListChangeSetsRequest): ListChangeSetsResponse

    /**
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
     *
     * For more information, see [ CloudFormation export stack output values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
     */
    public suspend fun listExports(input: ListExportsRequest = ListExportsRequest {}): ListExportsResponse

    /**
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.
     *
     * For more information about importing an exported output value, see the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
     */
    public suspend fun listImports(input: ListImportsRequest): ListImportsResponse

    /**
     * Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
     */
    public suspend fun listStackInstances(input: ListStackInstancesRequest): ListStackInstancesResponse

    /**
     * Returns descriptions of all resources of the specified stack.
     *
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.
     */
    public suspend fun listStackResources(input: ListStackResourcesRequest): ListStackResourcesResponse

    /**
     * Returns summary information about the results of a stack set operation.
     */
    public suspend fun listStackSetOperationResults(input: ListStackSetOperationResultsRequest): ListStackSetOperationResultsResponse

    /**
     * Returns summary information about operations performed on a stack set.
     */
    public suspend fun listStackSetOperations(input: ListStackSetOperationsRequest): ListStackSetOperationsResponse

    /**
     * Returns summary information about stack sets that are associated with the user.
     * + &#91;Self-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to your Amazon Web Services account, `ListStackSets` returns all self-managed stack sets in your Amazon Web Services account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to the organization's management account, `ListStackSets` returns all stack sets in the management account.
     * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `DELEGATED_ADMIN` while signed in to your member account, `ListStackSets` returns all stack sets with service-managed permissions in the management account.
     */
    public suspend fun listStackSets(input: ListStackSetsRequest = ListStackSetsRequest {}): ListStackSetsResponse

    /**
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
     */
    public suspend fun listStacks(input: ListStacksRequest = ListStacksRequest {}): ListStacksResponse

    /**
     * Returns a list of registration tokens for the specified extension(s).
     */
    public suspend fun listTypeRegistrations(input: ListTypeRegistrationsRequest = ListTypeRegistrationsRequest {}): ListTypeRegistrationsResponse

    /**
     * Returns summary information about the versions of an extension.
     */
    public suspend fun listTypeVersions(input: ListTypeVersionsRequest = ListTypeVersionsRequest {}): ListTypeVersionsResponse

    /**
     * Returns summary information about extension that have been registered with CloudFormation.
     */
    public suspend fun listTypes(input: ListTypesRequest = ListTypesRequest {}): ListTypesResponse

    /**
     * Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*.
     *
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
     */
    public suspend fun publishType(input: PublishTypeRequest = PublishTypeRequest {}): PublishTypeResponse

    /**
     * Reports progress of a resource handler to CloudFormation.
     *
     * Reserved for use by the [CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html). Don't use this API in your code.
     */
    public suspend fun recordHandlerProgress(input: RecordHandlerProgressRequest): RecordHandlerProgressResponse

    /**
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
     *
     * For information about requirements for registering as a public extension publisher, see [Registering your account to publish CloudFormation extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs) in the *CloudFormation CLI User Guide*.
     */
    public suspend fun registerPublisher(input: RegisterPublisherRequest = RegisterPublisherRequest {}): RegisterPublisherResponse

    /**
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
     * + Validating the extension schema.
     * + Determining which handlers, if any, have been specified for the extension.
     * + Making the extension available for use in your account.
     *
     * For more information about how to develop extensions and ready them for registration, see [Creating Resource Providers](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) in the *CloudFormation CLI User Guide*.
     *
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per region. Use [DeregisterType](AWSCloudFormation/latest/APIReference/API_DeregisterType.html) to deregister specific extension versions if necessary.
     *
     * Once you have initiated a registration request using ` <a>RegisterType</a> `, you can use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of the registration request.
     *
     * Once you have registered a private extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     */
    public suspend fun registerType(input: RegisterTypeRequest): RegisterTypeResponse

    /**
     * When specifying `RollbackStack`, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the DescribeStacks operation.
     *
     * Rolls back the specified stack to the last known stable state from `CREATE_FAILED` or `UPDATE_FAILED` stack statuses.
     *
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a `*_COMPLETE`. This includes the following stack statuses.
     * + `CREATE_COMPLETE`
     * + `UPDATE_COMPLETE`
     * + `UPDATE_ROLLBACK_COMPLETE`
     * + `IMPORT_COMPLETE`
     * + `IMPORT_ROLLBACK_COMPLETE`
     */
    public suspend fun rollbackStack(input: RollbackStackRequest): RollbackStackResponse

    /**
     * Sets a stack policy for a specified stack.
     */
    public suspend fun setStackPolicy(input: SetStackPolicyRequest): SetStackPolicyResponse

    /**
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and region.
     *
     * To view the current configuration data for an extension, refer to the `ConfigurationSchema` element of [DescribeType](AWSCloudFormation/latest/APIReference/API_DescribeType.html). For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
     *
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see [Using dynamic references to specify template values](https://docs.aws.amazon.com/) in the *CloudFormation User Guide*.
     */
    public suspend fun setTypeConfiguration(input: SetTypeConfigurationRequest): SetTypeConfigurationResponse

    /**
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
     */
    public suspend fun setTypeDefaultVersion(input: SetTypeDefaultVersionRequest = SetTypeDefaultVersionRequest {}): SetTypeDefaultVersionResponse

    /**
     * Sends a signal to the specified resource with a success or failure status. You can use the `SignalResource` operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The `SignalResource` operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
     */
    public suspend fun signalResource(input: SignalResourceRequest): SignalResourceResponse

    /**
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
     */
    public suspend fun stopStackSetOperation(input: StopStackSetOperationRequest): StopStackSetOperationResponse

    /**
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
     * + For resource types, this includes passing all contracts tests defined for the type.
     * + For modules, this includes determining if the module's model meets all necessary requirements.
     *
     * For more information, see [Testing your public extension prior to publishing](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing) in the *CloudFormation CLI User Guide*.
     *
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and region for testing.
     *
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see [RegisterType](AWSCloudFormation/latest/APIReference/API_RegisterType.html).
     *
     * Once you've initiated testing on an extension using `TestType`, you can pass the returned `TypeVersionArn` into [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html) to monitor the current test status and test status description for the extension.
     *
     * An extension must have a test status of `PASSED` before it can be published. For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html) in the *CloudFormation CLI User Guide*.
     */
    public suspend fun testType(input: TestTypeRequest = TestTypeRequest {}): TestTypeResponse

    /**
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the DescribeStacks action.
     *
     * To get a copy of the template for an existing stack, you can use the GetTemplate action.
     *
     * For more information about creating an update template, updating a stack, and monitoring the progress of the update, see [Updating a Stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
     */
    public suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse

    /**
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
     *
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to create additional stack instances, use [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
     *
     * During stack set updates, any parameters overridden for a stack instance aren't updated, but retain their overridden value.
     *
     * You can only update the parameter *values* that are specified in the stack set; to add or delete a parameter itself, use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
     */
    public suspend fun updateStackInstances(input: UpdateStackInstancesRequest): UpdateStackInstancesResponse

    /**
     * Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.
     *
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above a specified failure tolerance), the stack set is updated with your changes. Subsequent CreateStackInstances calls on the specified stack set use the updated stack set.
     */
    public suspend fun updateStackSet(input: UpdateStackSetRequest): UpdateStackSetResponse

    /**
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protecting a Stack From Being Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
     *
     * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
     */
    public suspend fun updateTerminationProtection(input: UpdateTerminationProtectionRequest): UpdateTerminationProtectionResponse

    /**
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
     */
    public suspend fun validateTemplate(input: ValidateTemplateRequest = ValidateTemplateRequest {}): ValidateTemplateResponse
}

/**
 * Activates a public third-party extension, making it available for use in stack templates. For more information, see [Using public extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html) in the *CloudFormation User Guide*.
 *
 * Once you have activated a public third-party extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.activateType(crossinline block: ActivateTypeRequest.Builder.() -> Unit): ActivateTypeResponse = activateType(ActivateTypeRequest.Builder().apply(block).build())

/**
 * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the account and region.
 *
 * For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.batchDescribeTypeConfigurations(crossinline block: BatchDescribeTypeConfigurationsRequest.Builder.() -> Unit): BatchDescribeTypeConfigurationsResponse = batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest.Builder().apply(block).build())

/**
 * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.
 *
 * You can cancel only stacks that are in the `UPDATE_IN_PROGRESS` state.
 */
public suspend inline fun CloudFormationClient.cancelUpdateStack(crossinline block: CancelUpdateStackRequest.Builder.() -> Unit): CancelUpdateStackResponse = cancelUpdateStack(CancelUpdateStackRequest.Builder().apply(block).build())

/**
 * For a specified stack that's in the `UPDATE_ROLLBACK_FAILED` state, continues rolling it back to the `UPDATE_ROLLBACK_COMPLETE` state. Depending on the cause of the failure, you can manually [ fix the error](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed) and continue the rollback. By continuing the rollback, you can return your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state), and then try to update the stack again.
 *
 * A stack goes into the `UPDATE_ROLLBACK_FAILED` state when CloudFormation can't roll back all changes after a failed stack update. For example, you might have a stack that's rolling back to an old database instance that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to fail.
 */
public suspend inline fun CloudFormationClient.continueUpdateRollback(crossinline block: ContinueUpdateRollbackRequest.Builder.() -> Unit): ContinueUpdateRollbackResponse = continueUpdateRollback(ContinueUpdateRollbackRequest.Builder().apply(block).build())

/**
 * Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.
 *
 * To create a change set for a stack that doesn't exist, for the `ChangeSetType` parameter, specify `CREATE`. To create a change set for an existing stack, specify `UPDATE` for the `ChangeSetType` parameter. To create a change set for an import operation, specify `IMPORT` for the `ChangeSetType` parameter. After the `CreateChangeSet` call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action.
 *
 * When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set.
 *
 * To create a change set for the entire stack hierarchy, set `IncludeNestedStacks` to `True`.
 */
public suspend inline fun CloudFormationClient.createChangeSet(crossinline block: CreateChangeSetRequest.Builder.() -> Unit): CreateChangeSetResponse = createChangeSet(CreateChangeSetRequest.Builder().apply(block).build())

/**
 * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the DescribeStacksoperation.
 */
public suspend inline fun CloudFormationClient.createStack(crossinline block: CreateStackRequest.Builder.() -> Unit): CreateStackResponse = createStack(CreateStackRequest.Builder().apply(block).build())

/**
 * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either `Accounts` or `DeploymentTargets`, and you must specify at least one value for `Regions`.
 */
public suspend inline fun CloudFormationClient.createStackInstances(crossinline block: CreateStackInstancesRequest.Builder.() -> Unit): CreateStackInstancesResponse = createStackInstances(CreateStackInstancesRequest.Builder().apply(block).build())

/**
 * Creates a stack set.
 */
public suspend inline fun CloudFormationClient.createStackSet(crossinline block: CreateStackSetRequest.Builder.() -> Unit): CreateStackSetResponse = createStackSet(CreateStackSetRequest.Builder().apply(block).build())

/**
 * Deactivates a public extension that was previously activated in this account and region.
 *
 * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
 */
public suspend inline fun CloudFormationClient.deactivateType(crossinline block: DeactivateTypeRequest.Builder.() -> Unit): DeactivateTypeResponse = deactivateType(DeactivateTypeRequest.Builder().apply(block).build())

/**
 * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
 *
 * If the call successfully completes, CloudFormation successfully deleted the change set.
 *
 * If `IncludeNestedStacks` specifies `True` during the creation of the nested change set, then `DeleteChangeSet` will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of `REVIEW_IN_PROGRESS`.
 */
public suspend inline fun CloudFormationClient.deleteChangeSet(crossinline block: DeleteChangeSetRequest.Builder.() -> Unit): DeleteChangeSetResponse = deleteChangeSet(DeleteChangeSetRequest.Builder().apply(block).build())

/**
 * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show up in the DescribeStacks operation if the deletion has been completed successfully.
 */
public suspend inline fun CloudFormationClient.deleteStack(crossinline block: DeleteStackRequest.Builder.() -> Unit): DeleteStackResponse = deleteStack(DeleteStackRequest.Builder().apply(block).build())

/**
 * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
 */
public suspend inline fun CloudFormationClient.deleteStackInstances(crossinline block: DeleteStackInstancesRequest.Builder.() -> Unit): DeleteStackInstancesResponse = deleteStackInstances(DeleteStackInstancesRequest.Builder().apply(block).build())

/**
 * Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more information about how to complete this, see DeleteStackInstances.
 */
public suspend inline fun CloudFormationClient.deleteStackSet(crossinline block: DeleteStackSetRequest.Builder.() -> Unit): DeleteStackSetResponse = deleteStackSet(DeleteStackSetRequest.Builder().apply(block).build())

/**
 * Marks an extension or extension version as `DEPRECATED` in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
 *
 * To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.
 *
 * You can't deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the extension type itself is deregistered as well and marked as deprecated.
 *
 * To view the deprecation status of an extension or extension version, use [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
 */
public suspend inline fun CloudFormationClient.deregisterType(crossinline block: DeregisterTypeRequest.Builder.() -> Unit): DeregisterTypeResponse = deregisterType(DeregisterTypeRequest.Builder().apply(block).build())

/**
 * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see [CloudFormation Quotas](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see [Updating Stacks Using Change Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html) in the CloudFormation User Guide.
 */
public suspend inline fun CloudFormationClient.describeChangeSet(crossinline block: DescribeChangeSetRequest.Builder.() -> Unit): DescribeChangeSetResponse = describeChangeSet(DescribeChangeSetRequest.Builder().apply(block).build())

/**
 * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run the change set.
 */
public suspend inline fun CloudFormationClient.describeChangeSetHooks(crossinline block: DescribeChangeSetHooksRequest.Builder.() -> Unit): DescribeChangeSetHooksResponse = describeChangeSetHooks(DescribeChangeSetHooksRequest.Builder().apply(block).build())

/**
 * Returns information about a CloudFormation extension publisher.
 *
 * If you don't supply a `PublisherId`, and you have registered as an extension publisher, `DescribePublisher` returns information about your own publisher account.
 *
 * For more information about registering as a publisher, see:
 * + [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html)
 * + [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*
 */
public suspend inline fun CloudFormationClient.describePublisher(crossinline block: DescribePublisherRequest.Builder.() -> Unit): DescribePublisherResponse = describePublisher(DescribePublisherRequest.Builder().apply(block).build())

/**
 * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use DetectStackDrift to initiate a stack drift detection operation. `DetectStackDrift` returns a `StackDriftDetectionId` you can use to monitor the progress of the operation using `DescribeStackDriftDetectionStatus`. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
 */
public suspend inline fun CloudFormationClient.describeStackDriftDetectionStatus(crossinline block: DescribeStackDriftDetectionStatusRequest.Builder.() -> Unit): DescribeStackDriftDetectionStatusResponse = describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.Builder().apply(block).build())

/**
 * Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack's event history, go to [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html) in the CloudFormation User Guide.
 *
 * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).
 */
public suspend inline fun CloudFormationClient.describeStackEvents(crossinline block: DescribeStackEventsRequest.Builder.() -> Unit): DescribeStackEventsResponse = describeStackEvents(DescribeStackEventsRequest.Builder().apply(block).build())

/**
 * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and Region.
 *
 * For a list of stack instances that are associated with a specific stack set, use ListStackInstances.
 */
public suspend inline fun CloudFormationClient.describeStackInstance(crossinline block: DescribeStackInstanceRequest.Builder.() -> Unit): DescribeStackInstanceResponse = describeStackInstance(DescribeStackInstanceRequest.Builder().apply(block).build())

/**
 * Returns a description of the specified resource in the specified stack.
 *
 * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.
 */
public suspend inline fun CloudFormationClient.describeStackResource(crossinline block: DescribeStackResourceRequest.Builder.() -> Unit): DescribeStackResourceResponse = describeStackResource(DescribeStackResourceRequest.Builder().apply(block).build())

/**
 * Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
 *
 * For a given stack, there will be one `StackResourceDrift` for each stack resource that has been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't currently support drift detection aren't checked, and so not included. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
 *
 * Use DetectStackResourceDrift to detect drift on individual resources, or DetectStackDrift to detect drift on all supported resources for a given stack.
 */
public suspend inline fun CloudFormationClient.describeStackResourceDrifts(crossinline block: DescribeStackResourceDriftsRequest.Builder.() -> Unit): DescribeStackResourceDriftsResponse = describeStackResourceDrifts(DescribeStackResourceDriftsRequest.Builder().apply(block).build())

/**
 * Returns Amazon Web Services resource descriptions for running and deleted stacks. If `StackName` is specified, all the associated resources that are part of the stack are returned. If `PhysicalResourceId` is specified, the associated resources of the stack that the resource belongs to are returned.
 *
 * Only the first 100 resources will be returned. If your stack has more resources than this, you should use `ListStackResources` instead.
 *
 * For deleted stacks, `DescribeStackResources` returns resource information for up to 90 days after the stack has been deleted.
 *
 * You must specify either `StackName` or `PhysicalResourceId`, but not both. In addition, you can specify `LogicalResourceId` to filter the returned result. For more information about resources, the `LogicalResourceId` and `PhysicalResourceId`, go to the [CloudFormation User Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
 *
 * A `ValidationError` is returned if you specify both `StackName` and `PhysicalResourceId` in the same request.
 */
public suspend inline fun CloudFormationClient.describeStackResources(crossinline block: DescribeStackResourcesRequest.Builder.() -> Unit): DescribeStackResourcesResponse = describeStackResources(DescribeStackResourcesRequest.Builder().apply(block).build())

/**
 * Returns the description of the specified stack set.
 */
public suspend inline fun CloudFormationClient.describeStackSet(crossinline block: DescribeStackSetRequest.Builder.() -> Unit): DescribeStackSetResponse = describeStackSet(DescribeStackSetRequest.Builder().apply(block).build())

/**
 * Returns the description of the specified stack set operation.
 */
public suspend inline fun CloudFormationClient.describeStackSetOperation(crossinline block: DescribeStackSetOperationRequest.Builder.() -> Unit): DescribeStackSetOperationResponse = describeStackSetOperation(DescribeStackSetOperationRequest.Builder().apply(block).build())

/**
 * Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.
 *
 * If the stack doesn't exist, an `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.describeStacks(crossinline block: DescribeStacksRequest.Builder.() -> Unit): DescribeStacksResponse = describeStacks(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Returns detailed information about an extension that has been registered.
 *
 * If you specify a `VersionId`, `DescribeType` returns information about that specific extension version. Otherwise, it returns information about the default extension version.
 */
public suspend inline fun CloudFormationClient.describeType(crossinline block: DescribeTypeRequest.Builder.() -> Unit): DescribeTypeResponse = describeType(DescribeTypeRequest.Builder().apply(block).build())

/**
 * Returns information about an extension's registration, including its current status and type and version identifiers.
 *
 * When you initiate a registration request using ` <a>RegisterType</a> `, you can then use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of that registration request.
 *
 * Once the registration request has completed, use ` <a>DescribeType</a> ` to return detailed information about an extension.
 */
public suspend inline fun CloudFormationClient.describeTypeRegistration(crossinline block: DescribeTypeRegistrationRequest.Builder.() -> Unit): DescribeTypeRegistrationResponse = describeTypeRegistration(DescribeTypeRegistrationRequest.Builder().apply(block).build())

/**
 * Detects whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use `DetectStackDrift` to detect drift on all supported resources for a given stack, or DetectStackResourceDrift to detect drift on individual resources.
 *
 * For a list of stack resources that currently support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
 *
 * `DetectStackDrift` can take up to several minutes, depending on the number of resources contained within the stack. Use DescribeStackDriftDetectionStatus to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use DescribeStackResourceDrifts to return drift information about the stack and its resources.
 *
 * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that stack. Perform `DetectStackDrift` directly on the nested stack itself.
 */
public suspend inline fun CloudFormationClient.detectStackDrift(crossinline block: DetectStackDriftRequest.Builder.() -> Unit): DetectStackDriftResponse = detectStackDrift(DetectStackDriftRequest.Builder().apply(block).build())

/**
 * Returns information about whether a resource's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see [Detecting Unregulated Configuration Changes to Stacks and Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
 *
 * Use `DetectStackResourceDrift` to detect drift on individual resources, or DetectStackDrift to detect drift on all resources in a given stack that support drift detection.
 *
 * Resources that don't currently support drift detection can't be checked. For a list of resources that support drift detection, see [Resources that Support Drift Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
 */
public suspend inline fun CloudFormationClient.detectStackResourceDrift(crossinline block: DetectStackResourceDriftRequest.Builder.() -> Unit): DetectStackResourceDriftResponse = detectStackResourceDrift(DetectStackResourceDriftRequest.Builder().apply(block).build())

/**
 * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see [How CloudFormation performs drift detection on a stack set](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
 *
 * `DetectStackSetDrift` returns the `OperationId` of the stack set drift detection operation. Use this operation id with ` <a>DescribeStackSetOperation</a> ` to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the stack set, in addition to the number of resources included in each stack.
 *
 * Once the operation has completed, use the following actions to return drift information:
 * + Use ` <a>DescribeStackSet</a> ` to return detailed information about the stack set, including detailed information about the last *completed* drift operation performed on the stack set. (Information about drift operations that are in progress isn't included.)
 * + Use ` <a>ListStackInstances</a> ` to return a list of stack instances belonging to the stack set, including the drift status and last drift time checked of each instance.
 * + Use ` <a>DescribeStackInstance</a> ` to return detailed information about a specific stack instance, including its drift status and last drift time checked.
 *
 * For more information about performing a drift detection operation on a stack set, see [Detecting unmanaged changes in stack sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
 *
 * You can only run a single drift detection operation on a given stack set at one time.
 *
 * To stop a drift detection stack set operation, use ` <a>StopStackSetOperation</a> `.
 */
public suspend inline fun CloudFormationClient.detectStackSetDrift(crossinline block: DetectStackSetDriftRequest.Builder.() -> Unit): DetectStackSetDriftResponse = detectStackSetDrift(DetectStackSetDriftRequest.Builder().apply(block).build())

/**
 * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.
 */
public suspend inline fun CloudFormationClient.estimateTemplateCost(crossinline block: EstimateTemplateCostRequest.Builder.() -> Unit): EstimateTemplateCostResponse = estimateTemplateCost(EstimateTemplateCostRequest.Builder().apply(block).build())

/**
 * Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update.
 *
 * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack.
 *
 * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy.
 *
 * To create a change set for the entire stack hierarchy, `IncludeNestedStacks` must have been set to `True`.
 */
public suspend inline fun CloudFormationClient.executeChangeSet(crossinline block: ExecuteChangeSetRequest.Builder.() -> Unit): ExecuteChangeSetResponse = executeChangeSet(ExecuteChangeSetRequest.Builder().apply(block).build())

/**
 * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
 */
public suspend inline fun CloudFormationClient.getStackPolicy(crossinline block: GetStackPolicyRequest.Builder.() -> Unit): GetStackPolicyResponse = getStackPolicy(GetStackPolicyRequest.Builder().apply(block).build())

/**
 * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
 *
 * For deleted stacks, `GetTemplate` returns the template for up to 90 days after the stack has been deleted.
 *
 * If the template doesn't exist, a `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.getTemplate(crossinline block: GetTemplateRequest.Builder.() -> Unit): GetTemplateResponse = getTemplate(GetTemplateRequest.Builder().apply(block).build())

/**
 * Returns information about a new or existing template. The `GetTemplateSummary` action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or stack set.
 *
 * You can use the `GetTemplateSummary` action when you submit a template, or you can get template information for a stack set, or a running or deleted stack.
 *
 * For deleted stacks, `GetTemplateSummary` returns the template information for up to 90 days after the stack has been deleted. If the template doesn't exist, a `ValidationError` is returned.
 */
public suspend inline fun CloudFormationClient.getTemplateSummary(crossinline block: GetTemplateSummaryRequest.Builder.() -> Unit): GetTemplateSummaryResponse = getTemplateSummary(GetTemplateSummaryRequest.Builder().apply(block).build())

/**
 * Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.
 *
 * `ImportStacksToStackSet` is only supported by self-managed permissions.
 */
public suspend inline fun CloudFormationClient.importStacksToStackSet(crossinline block: ImportStacksToStackSetRequest.Builder.() -> Unit): ImportStacksToStackSetResponse = importStacksToStackSet(ImportStacksToStackSetRequest.Builder().apply(block).build())

/**
 * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
 */
public suspend inline fun CloudFormationClient.listChangeSets(crossinline block: ListChangeSetsRequest.Builder.() -> Unit): ListChangeSetsResponse = listChangeSets(ListChangeSetsRequest.Builder().apply(block).build())

/**
 * Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
 *
 * For more information, see [ CloudFormation export stack output values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
 */
public suspend inline fun CloudFormationClient.listExports(crossinline block: ListExportsRequest.Builder.() -> Unit): ListExportsResponse = listExports(ListExportsRequest.Builder().apply(block).build())

/**
 * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.
 *
 * For more information about importing an exported output value, see the `Fn::ImportValue`[](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) function.
 */
public suspend inline fun CloudFormationClient.listImports(crossinline block: ListImportsRequest.Builder.() -> Unit): ListImportsResponse = listImports(ListImportsRequest.Builder().apply(block).build())

/**
 * Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.
 */
public suspend inline fun CloudFormationClient.listStackInstances(crossinline block: ListStackInstancesRequest.Builder.() -> Unit): ListStackInstancesResponse = listStackInstances(ListStackInstancesRequest.Builder().apply(block).build())

/**
 * Returns descriptions of all resources of the specified stack.
 *
 * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.
 */
public suspend inline fun CloudFormationClient.listStackResources(crossinline block: ListStackResourcesRequest.Builder.() -> Unit): ListStackResourcesResponse = listStackResources(ListStackResourcesRequest.Builder().apply(block).build())

/**
 * Returns summary information about the results of a stack set operation.
 */
public suspend inline fun CloudFormationClient.listStackSetOperationResults(crossinline block: ListStackSetOperationResultsRequest.Builder.() -> Unit): ListStackSetOperationResultsResponse = listStackSetOperationResults(ListStackSetOperationResultsRequest.Builder().apply(block).build())

/**
 * Returns summary information about operations performed on a stack set.
 */
public suspend inline fun CloudFormationClient.listStackSetOperations(crossinline block: ListStackSetOperationsRequest.Builder.() -> Unit): ListStackSetOperationsResponse = listStackSetOperations(ListStackSetOperationsRequest.Builder().apply(block).build())

/**
 * Returns summary information about stack sets that are associated with the user.
 * + &#91;Self-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to your Amazon Web Services account, `ListStackSets` returns all self-managed stack sets in your Amazon Web Services account.
 * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `SELF` while signed in to the organization's management account, `ListStackSets` returns all stack sets in the management account.
 * + &#91;Service-managed permissions&#93; If you set the `CallAs` parameter to `DELEGATED_ADMIN` while signed in to your member account, `ListStackSets` returns all stack sets with service-managed permissions in the management account.
 */
public suspend inline fun CloudFormationClient.listStackSets(crossinline block: ListStackSetsRequest.Builder.() -> Unit): ListStackSetsResponse = listStackSets(ListStackSetsRequest.Builder().apply(block).build())

/**
 * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).
 */
public suspend inline fun CloudFormationClient.listStacks(crossinline block: ListStacksRequest.Builder.() -> Unit): ListStacksResponse = listStacks(ListStacksRequest.Builder().apply(block).build())

/**
 * Returns a list of registration tokens for the specified extension(s).
 */
public suspend inline fun CloudFormationClient.listTypeRegistrations(crossinline block: ListTypeRegistrationsRequest.Builder.() -> Unit): ListTypeRegistrationsResponse = listTypeRegistrations(ListTypeRegistrationsRequest.Builder().apply(block).build())

/**
 * Returns summary information about the versions of an extension.
 */
public suspend inline fun CloudFormationClient.listTypeVersions(crossinline block: ListTypeVersionsRequest.Builder.() -> Unit): ListTypeVersionsResponse = listTypeVersions(ListTypeVersionsRequest.Builder().apply(block).build())

/**
 * Returns summary information about extension that have been registered with CloudFormation.
 */
public suspend inline fun CloudFormationClient.listTypes(crossinline block: ListTypesRequest.Builder.() -> Unit): ListTypesResponse = listTypes(ListTypesRequest.Builder().apply(block).build())

/**
 * Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public extensions are available for use by all CloudFormation users. For more information about publishing extensions, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation CLI User Guide*.
 *
 * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see [RegisterPublisher](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html).
 */
public suspend inline fun CloudFormationClient.publishType(crossinline block: PublishTypeRequest.Builder.() -> Unit): PublishTypeResponse = publishType(PublishTypeRequest.Builder().apply(block).build())

/**
 * Reports progress of a resource handler to CloudFormation.
 *
 * Reserved for use by the [CloudFormation CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html). Don't use this API in your code.
 */
public suspend inline fun CloudFormationClient.recordHandlerProgress(crossinline block: RecordHandlerProgressRequest.Builder.() -> Unit): RecordHandlerProgressResponse = recordHandlerProgress(RecordHandlerProgressRequest.Builder().apply(block).build())

/**
 * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web Services Regions.
 *
 * For information about requirements for registering as a public extension publisher, see [Registering your account to publish CloudFormation extensions](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs) in the *CloudFormation CLI User Guide*.
 */
public suspend inline fun CloudFormationClient.registerPublisher(crossinline block: RegisterPublisherRequest.Builder.() -> Unit): RegisterPublisherResponse = registerPublisher(RegisterPublisherRequest.Builder().apply(block).build())

/**
 * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your Amazon Web Services account, and includes:
 * + Validating the extension schema.
 * + Determining which handlers, if any, have been specified for the extension.
 * + Making the extension available for use in your account.
 *
 * For more information about how to develop extensions and ready them for registration, see [Creating Resource Providers](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) in the *CloudFormation CLI User Guide*.
 *
 * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per region. Use [DeregisterType](AWSCloudFormation/latest/APIReference/API_DeregisterType.html) to deregister specific extension versions if necessary.
 *
 * Once you have initiated a registration request using ` <a>RegisterType</a> `, you can use ` <a>DescribeTypeRegistration</a> ` to monitor the progress of the registration request.
 *
 * Once you have registered a private extension in your account and region, use [SetTypeConfiguration](AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html) to specify configuration properties for the extension. For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.registerType(crossinline block: RegisterTypeRequest.Builder.() -> Unit): RegisterTypeResponse = registerType(RegisterTypeRequest.Builder().apply(block).build())

/**
 * When specifying `RollbackStack`, you preserve the state of previously provisioned resources when an operation fails. You can check the status of the stack through the DescribeStacks operation.
 *
 * Rolls back the specified stack to the last known stable state from `CREATE_FAILED` or `UPDATE_FAILED` stack statuses.
 *
 * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state includes any status in a `*_COMPLETE`. This includes the following stack statuses.
 * + `CREATE_COMPLETE`
 * + `UPDATE_COMPLETE`
 * + `UPDATE_ROLLBACK_COMPLETE`
 * + `IMPORT_COMPLETE`
 * + `IMPORT_ROLLBACK_COMPLETE`
 */
public suspend inline fun CloudFormationClient.rollbackStack(crossinline block: RollbackStackRequest.Builder.() -> Unit): RollbackStackResponse = rollbackStack(RollbackStackRequest.Builder().apply(block).build())

/**
 * Sets a stack policy for a specified stack.
 */
public suspend inline fun CloudFormationClient.setStackPolicy(crossinline block: SetStackPolicyRequest.Builder.() -> Unit): SetStackPolicyResponse = setStackPolicy(SetStackPolicyRequest.Builder().apply(block).build())

/**
 * Specifies the configuration data for a registered CloudFormation extension, in the given account and region.
 *
 * To view the current configuration data for an extension, refer to the `ConfigurationSchema` element of [DescribeType](AWSCloudFormation/latest/APIReference/API_DescribeType.html). For more information, see [Configuring extensions at the account level](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration) in the *CloudFormation User Guide*.
 *
 * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see [Using dynamic references to specify template values](https://docs.aws.amazon.com/) in the *CloudFormation User Guide*.
 */
public suspend inline fun CloudFormationClient.setTypeConfiguration(crossinline block: SetTypeConfigurationRequest.Builder.() -> Unit): SetTypeConfigurationResponse = setTypeConfiguration(SetTypeConfigurationRequest.Builder().apply(block).build())

/**
 * Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.
 */
public suspend inline fun CloudFormationClient.setTypeDefaultVersion(crossinline block: SetTypeDefaultVersionRequest.Builder.() -> Unit): SetTypeDefaultVersionResponse = setTypeDefaultVersion(SetTypeDefaultVersionRequest.Builder().apply(block).build())

/**
 * Sends a signal to the specified resource with a success or failure status. You can use the `SignalResource` operation in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The `SignalResource` operation is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.
 */
public suspend inline fun CloudFormationClient.signalResource(crossinline block: SignalResourceRequest.Builder.() -> Unit): SignalResourceResponse = signalResource(SignalResourceRequest.Builder().apply(block).build())

/**
 * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the unstarted stack instance deployments and wait for those are in-progress to complete.
 */
public suspend inline fun CloudFormationClient.stopStackSetOperation(crossinline block: StopStackSetOperationRequest.Builder.() -> Unit): StopStackSetOperationResponse = stopStackSetOperation(StopStackSetOperationRequest.Builder().apply(block).build())

/**
 * Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.
 * + For resource types, this includes passing all contracts tests defined for the type.
 * + For modules, this includes determining if the module's model meets all necessary requirements.
 *
 * For more information, see [Testing your public extension prior to publishing](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing) in the *CloudFormation CLI User Guide*.
 *
 * If you don't specify a version, CloudFormation uses the default version of the extension in your account and region for testing.
 *
 * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see [RegisterType](AWSCloudFormation/latest/APIReference/API_RegisterType.html).
 *
 * Once you've initiated testing on an extension using `TestType`, you can pass the returned `TypeVersionArn` into [DescribeType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html) to monitor the current test status and test status description for the extension.
 *
 * An extension must have a test status of `PASSED` before it can be published. For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html) in the *CloudFormation CLI User Guide*.
 */
public suspend inline fun CloudFormationClient.testType(crossinline block: TestTypeRequest.Builder.() -> Unit): TestTypeResponse = testType(TestTypeRequest.Builder().apply(block).build())

/**
 * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack through the DescribeStacks action.
 *
 * To get a copy of the template for an existing stack, you can use the GetTemplate action.
 *
 * For more information about creating an update template, updating a stack, and monitoring the progress of the update, see [Updating a Stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
 */
public suspend inline fun CloudFormationClient.updateStack(crossinline block: UpdateStackRequest.Builder.() -> Unit): UpdateStackResponse = updateStack(UpdateStackRequest.Builder().apply(block).build())

/**
 * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack instance refers to a stack in a specific account and Region.
 *
 * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to create additional stack instances, use [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
 *
 * During stack set updates, any parameters overridden for a stack instance aren't updated, but retain their overridden value.
 *
 * You can only update the parameter *values* that are specified in the stack set; to add or delete a parameter itself, use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html) to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using `UpdateStackInstances`.
 */
public suspend inline fun CloudFormationClient.updateStackInstances(crossinline block: UpdateStackInstancesRequest.Builder.() -> Unit): UpdateStackInstancesResponse = updateStackInstances(UpdateStackInstancesRequest.Builder().apply(block).build())

/**
 * Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.
 *
 * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above a specified failure tolerance), the stack set is updated with your changes. Subsequent CreateStackInstances calls on the specified stack set use the updated stack set.
 */
public suspend inline fun CloudFormationClient.updateStackSet(crossinline block: UpdateStackSetRequest.Builder.() -> Unit): UpdateStackSetResponse = updateStackSet(UpdateStackSetRequest.Builder().apply(block).build())

/**
 * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see [Protecting a Stack From Being Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
 *
 * For [nested stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack.
 */
public suspend inline fun CloudFormationClient.updateTerminationProtection(crossinline block: UpdateTerminationProtectionRequest.Builder.() -> Unit): UpdateTerminationProtectionResponse = updateTerminationProtection(UpdateTerminationProtectionRequest.Builder().apply(block).build())

/**
 * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.
 */
public suspend inline fun CloudFormationClient.validateTemplate(crossinline block: ValidateTemplateRequest.Builder.() -> Unit): ValidateTemplateResponse = validateTemplate(ValidateTemplateRequest.Builder().apply(block).build())
