// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



public class CreateStackSetRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
     *
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see [Prerequisites: Granting Permissions for Stack Set Operations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
     */
    public val administrationRoleArn: kotlin.String? = builder.administrationRoleArn
    /**
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target organization or organizational unit (OU). Specify only if `PermissionModel` is `SERVICE_MANAGED`.
     */
    public val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
     * + To create a stack set with service-managed permissions while signed in to the management account, specify `SELF`.
     * + To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated admin in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     *
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in order for CloudFormation to create the stack set and related stack instances.
     * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
     *    + If you have IAM resources, you can specify either capability.
     *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
     *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
     * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
     *    + [ AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
     *    + [ AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
     *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
     *    + [ AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
     *    + [ AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
     *    + [ AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
     *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
     * For more information, see [Acknowledging IAM Resources in CloudFormation Templates](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
     * + `CAPABILITY_AUTO_EXPAND`Some templates reference macros. If your stack set template references one or more macros, you must create the stack set directly from the processed template, without first reviewing the resulting changes in a change set. To create the stack set directly, you must acknowledge this capability. For more information, see [Using CloudFormation Macros to Perform Custom Processing on Templates](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).Stack sets with service-managed permissions don't currently support the use of macros in templates. (This includes the [AWS::Include](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html) and [AWS::Serverless](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.) Even if you specify this capability for a stack set with service-managed permissions, if you reference a macro in your template the stack set operation will fail.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * A unique identifier for this `CreateStackSet` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to create another stack set with the same name. You might retry `CreateStackSet` requests to ensure that CloudFormation successfully received them.
     *
     * If you don't specify an operation ID, the SDK generates one automatically.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A description of the stack set. You can use the description to identify the stack set's purpose or other important information.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role, CloudFormation uses the `AWSCloudFormationStackSetExecutionRole` role for the stack set operation.
     *
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their stack sets.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     */
    public val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * The input parameters for the stack set template.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * Describes how the IAM roles required for stack set operations are created. By default, `SELF-MANAGED` is specified.
     * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant Self-Managed Stack Set Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
     * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Grant Service-Managed Stack Set Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
     */
    public val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     *
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and can't be longer than 128 characters.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.
     *
     * If you specify tags as part of a `CreateStackSet` action, CloudFormation checks to see if you have the required IAM permission to tag resources. If you don't, the entire `CreateStackSet` action fails with an `access denied` error, and the stack set is not created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see [Template Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html) in the CloudFormation User Guide.
     *
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see [Template Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html) in the CloudFormation User Guide.
     *
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStackSetRequest(")
        append("administrationRoleArn=$administrationRoleArn,")
        append("autoDeployment=$autoDeployment,")
        append("callAs=$callAs,")
        append("capabilities=$capabilities,")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("executionRoleName=$executionRoleName,")
        append("managedExecution=$managedExecution,")
        append("parameters=$parameters,")
        append("permissionModel=$permissionModel,")
        append("stackId=$stackId,")
        append("stackSetName=$stackSetName,")
        append("tags=$tags,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrationRoleArn?.hashCode() ?: 0
        result = 31 * result + (autoDeployment?.hashCode() ?: 0)
        result = 31 * result + (callAs?.hashCode() ?: 0)
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStackSetRequest

        if (administrationRoleArn != other.administrationRoleArn) return false
        if (autoDeployment != other.autoDeployment) return false
        if (callAs != other.callAs) return false
        if (capabilities != other.capabilities) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (executionRoleName != other.executionRoleName) return false
        if (managedExecution != other.managedExecution) return false
        if (parameters != other.parameters) return false
        if (permissionModel != other.permissionModel) return false
        if (stackId != other.stackId) return false
        if (stackSetName != other.stackSetName) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
         *
         * Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see [Prerequisites: Granting Permissions for Stack Set Operations](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
         */
        public var administrationRoleArn: kotlin.String? = null
        /**
         * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target organization or organizational unit (OU). Specify only if `PermissionModel` is `SERVICE_MANAGED`.
         */
        public var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
         * + To create a stack set with service-managed permissions while signed in to the management account, specify `SELF`.
         * + To create a stack set with service-managed permissions while signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated admin in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         *
         * Stack sets with service-managed permissions are created in the management account, including stack sets that are created by delegated administrators.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in order for CloudFormation to create the stack set and related stack instances.
         * + `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying one of these capabilities.The following IAM resources require you to specify either the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
         *    + If you have IAM resources, you can specify either capability.
         *    + If you have IAM resources with custom names, you *must* specify `CAPABILITY_NAMED_IAM`.
         *    + If you don't specify either of these capabilities, CloudFormation returns an `InsufficientCapabilities` error.
         * If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.
         *    + [ AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
         *    + [ AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
         *    + [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
         *    + [ AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
         *    + [ AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
         *    + [ AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
         *    + [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
         * For more information, see [Acknowledging IAM Resources in CloudFormation Templates](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
         * + `CAPABILITY_AUTO_EXPAND`Some templates reference macros. If your stack set template references one or more macros, you must create the stack set directly from the processed template, without first reviewing the resulting changes in a change set. To create the stack set directly, you must acknowledge this capability. For more information, see [Using CloudFormation Macros to Perform Custom Processing on Templates](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).Stack sets with service-managed permissions don't currently support the use of macros in templates. (This includes the [AWS::Include](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html) and [AWS::Serverless](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html) transforms, which are macros hosted by CloudFormation.) Even if you specify this capability for a stack set with service-managed permissions, if you reference a macro in your template the stack set operation will fail.
         */
        public var capabilities: List<Capability>? = null
        /**
         * A unique identifier for this `CreateStackSet` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to create another stack set with the same name. You might retry `CreateStackSet` requests to ensure that CloudFormation successfully received them.
         *
         * If you don't specify an operation ID, the SDK generates one automatically.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A description of the stack set. You can use the description to identify the stack set's purpose or other important information.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role, CloudFormation uses the `AWSCloudFormationStackSetExecutionRole` role for the stack set operation.
         *
         * Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their stack sets.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
         */
        public var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * The input parameters for the stack set template.
         */
        public var parameters: List<Parameter>? = null
        /**
         * Describes how the IAM roles required for stack set operations are created. By default, `SELF-MANAGED` is specified.
         * + With `self-managed` permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see [Grant Self-Managed Stack Set Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
         * + With `service-managed` permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see [Grant Service-Managed Stack Set Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html).
         */
        public var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
         */
        public var stackId: kotlin.String? = null
        /**
         * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
         *
         * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and can't be longer than 128 characters.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.
         *
         * If you specify tags as part of a `CreateStackSet` action, CloudFormation checks to see if you have the required IAM permission to tag resources. If you don't, the entire `CreateStackSet` action fails with an `access denied` error, and the stack set is not created.
         */
        public var tags: List<Tag>? = null
        /**
         * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see [Template Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html) in the CloudFormation User Guide.
         *
         * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         */
        public var templateBody: kotlin.String? = null
        /**
         * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see [Template Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html) in the CloudFormation User Guide.
         *
         * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         */
        public var templateUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest) : this() {
            this.administrationRoleArn = x.administrationRoleArn
            this.autoDeployment = x.autoDeployment
            this.callAs = x.callAs
            this.capabilities = x.capabilities
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.executionRoleName = x.executionRoleName
            this.managedExecution = x.managedExecution
            this.parameters = x.parameters
            this.permissionModel = x.permissionModel
            this.stackId = x.stackId
            this.stackSetName = x.stackSetName
            this.tags = x.tags
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest = CreateStackSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        public fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        public fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }
    }
}
