// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Describes the target resources of a specific type in your import template (for example, all `AWS::S3::Bucket` resources) and the properties you can provide during the import to identify resources of that type.
 */
public class ResourceIdentifierSummary private constructor(builder: Builder) {
    /**
     * The logical IDs of the target resources of the specified `ResourceType`, as defined in the import template.
     */
    public val logicalResourceIds: List<String>? = builder.logicalResourceIds
    /**
     * The resource properties you can provide during the import to identify your target resources. For example, `BucketName` is a possible identifier property for `AWS::S3::Bucket` resources.
     */
    public val resourceIdentifiers: List<String>? = builder.resourceIdentifiers
    /**
     * The template resource type of the target resources, such as `AWS::S3::Bucket`.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceIdentifierSummary(")
        append("logicalResourceIds=$logicalResourceIds,")
        append("resourceIdentifiers=$resourceIdentifiers,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceIds?.hashCode() ?: 0
        result = 31 * result + (resourceIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceIdentifierSummary

        if (logicalResourceIds != other.logicalResourceIds) return false
        if (resourceIdentifiers != other.resourceIdentifiers) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The logical IDs of the target resources of the specified `ResourceType`, as defined in the import template.
         */
        public var logicalResourceIds: List<String>? = null
        /**
         * The resource properties you can provide during the import to identify your target resources. For example, `BucketName` is a possible identifier property for `AWS::S3::Bucket` resources.
         */
        public var resourceIdentifiers: List<String>? = null
        /**
         * The template resource type of the target resources, such as `AWS::S3::Bucket`.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary) : this() {
            this.logicalResourceIds = x.logicalResourceIds
            this.resourceIdentifiers = x.resourceIdentifiers
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceIdentifierSummary = ResourceIdentifierSummary(this)
    }
}
