// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Stack data type.
 */
public class Stack private constructor(builder: Builder) {
    /**
     * The capabilities allowed in the stack.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The unique ID of the change set.
     */
    public val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * The time at which the stack was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time the stack was deleted.
     */
    public val deletionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionTime
    /**
     * A user-defined description associated with the stack.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Boolean to enable or disable rollback on stack creation failures:
     * + `true`: disable rollback.
     * + `false`: enable rollback.
     */
    public val disableRollback: kotlin.Boolean? = builder.disableRollback
    /**
     * Information about whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
     */
    public val driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation? = builder.driftInformation
    /**
     * Whether termination protection is enabled for the stack.
     *
     * For [nested stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack. For more information, see [Protecting a Stack From Being Deleted](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
     */
    public val enableTerminationProtection: kotlin.Boolean? = builder.enableTerminationProtection
    /**
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
     */
    public val notificationArNs: List<String>? = builder.notificationArNs
    /**
     * A list of output structures.
     */
    public val outputs: List<Output>? = builder.outputs
    /**
     * A list of `Parameter` structures.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
     *
     * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val parentId: kotlin.String? = builder.parentId
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that's associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
     */
    public val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.
     *
     * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
     */
    public val rootId: kotlin.String? = builder.rootId
    /**
     * Unique identifier of the stack.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The name associated with the stack.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * Current status of the stack.
     */
    public val stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = builder.stackStatus
    /**
     * Success/failure message associated with the stack status.
     */
    public val stackStatusReason: kotlin.String? = builder.stackStatusReason
    /**
     * A list of `Tag`s that specify information about the stack.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The amount of time within which stack creation should complete.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.Stack = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stack(")
        append("capabilities=$capabilities,")
        append("changeSetId=$changeSetId,")
        append("creationTime=$creationTime,")
        append("deletionTime=$deletionTime,")
        append("description=$description,")
        append("disableRollback=$disableRollback,")
        append("driftInformation=$driftInformation,")
        append("enableTerminationProtection=$enableTerminationProtection,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("notificationArNs=$notificationArNs,")
        append("outputs=$outputs,")
        append("parameters=$parameters,")
        append("parentId=$parentId,")
        append("roleArn=$roleArn,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("rootId=$rootId,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("stackStatus=$stackStatus,")
        append("stackStatusReason=$stackStatusReason,")
        append("tags=$tags,")
        append("timeoutInMinutes=$timeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (changeSetId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deletionTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableRollback?.hashCode() ?: 0)
        result = 31 * result + (driftInformation?.hashCode() ?: 0)
        result = 31 * result + (enableTerminationProtection?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (notificationArNs?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (rootId?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackStatus?.hashCode() ?: 0)
        result = 31 * result + (stackStatusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stack

        if (capabilities != other.capabilities) return false
        if (changeSetId != other.changeSetId) return false
        if (creationTime != other.creationTime) return false
        if (deletionTime != other.deletionTime) return false
        if (description != other.description) return false
        if (disableRollback != other.disableRollback) return false
        if (driftInformation != other.driftInformation) return false
        if (enableTerminationProtection != other.enableTerminationProtection) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (notificationArNs != other.notificationArNs) return false
        if (outputs != other.outputs) return false
        if (parameters != other.parameters) return false
        if (parentId != other.parentId) return false
        if (roleArn != other.roleArn) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (rootId != other.rootId) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (stackStatus != other.stackStatus) return false
        if (stackStatusReason != other.stackStatusReason) return false
        if (tags != other.tags) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.Stack = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capabilities allowed in the stack.
         */
        public var capabilities: List<Capability>? = null
        /**
         * The unique ID of the change set.
         */
        public var changeSetId: kotlin.String? = null
        /**
         * The time at which the stack was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the stack was deleted.
         */
        public var deletionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A user-defined description associated with the stack.
         */
        public var description: kotlin.String? = null
        /**
         * Boolean to enable or disable rollback on stack creation failures:
         * + `true`: disable rollback.
         * + `false`: enable rollback.
         */
        public var disableRollback: kotlin.Boolean? = null
        /**
         * Information about whether a stack's actual configuration differs, or has *drifted*, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see [Detecting Unregulated Configuration Changes to Stacks and Resources](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
         */
        public var driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation? = null
        /**
         * Whether termination protection is enabled for the stack.
         *
         * For [nested stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html), termination protection is set on the root stack and can't be changed directly on the nested stack. For more information, see [Protecting a Stack From Being Deleted](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html) in the *CloudFormation User Guide*.
         */
        public var enableTerminationProtection: kotlin.Boolean? = null
        /**
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least once.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         */
        public var notificationArNs: List<String>? = null
        /**
         * A list of output structures.
         */
        public var outputs: List<Output>? = null
        /**
         * A list of `Parameter` structures.
         */
        public var parameters: List<Parameter>? = null
        /**
         * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.
         *
         * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var parentId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that's associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
         */
        public var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.
         *
         * For more information, see [Working with Nested Stacks](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html) in the *CloudFormation User Guide*.
         */
        public var rootId: kotlin.String? = null
        /**
         * Unique identifier of the stack.
         */
        public var stackId: kotlin.String? = null
        /**
         * The name associated with the stack.
         */
        public var stackName: kotlin.String? = null
        /**
         * Current status of the stack.
         */
        public var stackStatus: aws.sdk.kotlin.services.cloudformation.model.StackStatus? = null
        /**
         * Success/failure message associated with the stack status.
         */
        public var stackStatusReason: kotlin.String? = null
        /**
         * A list of `Tag`s that specify information about the stack.
         */
        public var tags: List<Tag>? = null
        /**
         * The amount of time within which stack creation should complete.
         */
        public var timeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.Stack) : this() {
            this.capabilities = x.capabilities
            this.changeSetId = x.changeSetId
            this.creationTime = x.creationTime
            this.deletionTime = x.deletionTime
            this.description = x.description
            this.disableRollback = x.disableRollback
            this.driftInformation = x.driftInformation
            this.enableTerminationProtection = x.enableTerminationProtection
            this.lastUpdatedTime = x.lastUpdatedTime
            this.notificationArNs = x.notificationArNs
            this.outputs = x.outputs
            this.parameters = x.parameters
            this.parentId = x.parentId
            this.roleArn = x.roleArn
            this.rollbackConfiguration = x.rollbackConfiguration
            this.rootId = x.rootId
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.stackStatus = x.stackStatus
            this.stackStatusReason = x.stackStatusReason
            this.tags = x.tags
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.Stack = Stack(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation] inside the given [block]
         */
        public fun driftInformation(block: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation.Builder.() -> kotlin.Unit) {
            this.driftInformation = aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        public fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }
    }
}
